/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.ui;

import dgt.jwizard.act.BackupTask;
import dgt.jwizard.ui.CreateProjectDialog;
import dgt.jwizard.ui.JWizard;
import dgt.jwizard.ui.SwingUtils;
import dgt.jwizard.ui.TeambaseWindow;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;

public class PanelProjects
extends JPanel {
    private JWizard mainWindow;
    private static final Color BTN_COLOR = null;
    private JFileChooser dirChooser;

    public PanelProjects(JWizard mainWindow) {
        this.mainWindow = mainWindow;
        this.setBorder(new TitledBorder("Projects"));
        this.setLayout(null);
        SwingUtils.IntWrapper Y = new SwingUtils.IntWrapper();
        Y.val = -10;
        this.createButton("&Create", "Create project with selected documents", Y, this::CreateProject);
        this.createButton("&Select", "Select project", Y, this::SelectProject);
        this.createButton("&Update", "Update current project with selected documents", Y, this::CreateProject);
        this.createButton("&Browse ", "Browse current project", Y, this::BrowseProject);
        Y.val = 150;
        this.createButton("Tea&m Base", "Shared memories", Y, this::OpenTeambaseWindow);
        this.createButton("C&lear", "Clear document selection", Y, this::ClearList);
        this.createButton("Back&Up ", "Force Backup", Y, this::Backup);
        this.dirChooser = new JFileChooser(new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath")));
        this.dirChooser.setFileSelectionMode(1);
        this.dirChooser.setPreferredSize(new Dimension((int)this.dirChooser.getPreferredSize().getWidth() + 100, (int)this.dirChooser.getPreferredSize().getHeight()));
        this.dirChooser.getActionMap().get("viewTypeDetails").actionPerformed(null);
    }

    private JButton createButton(String label, String tooltip, SwingUtils.IntWrapper Y, ActionListener listener) {
        Y.val += 30;
        if (label.length() <= 7) {
            return SwingUtils.createButton(this, label.trim(), tooltip, new Rectangle(38, Y.val, 75, 25), BTN_COLOR, listener);
        }
        if (label.length() <= 8) {
            return SwingUtils.createButton(this, label.trim(), tooltip, new Rectangle(33, Y.val, 85, 25), BTN_COLOR, listener);
        }
        return SwingUtils.createButton(this, label.trim(), tooltip, new Rectangle(20, Y.val, 110, 25), BTN_COLOR, listener);
    }

    private void BrowseProject(ActionEvent ev) {
        if (this.mainWindow.fdProject.getText() == null || this.mainWindow.fdProject.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "Cannot browse a 'blank' project !!!", "alert", 0);
            return;
        }
        File path = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + this.mainWindow.fdProject.getText().trim());
        if (!path.exists()) {
            JOptionPane.showMessageDialog(null, "Project '" + this.mainWindow.fdProject.getText() + "' does not exist yet !!!", "alert", 0);
            return;
        }
        this.mainWindow.msgArea.setText("Browsing project \"" + this.mainWindow.fdProject.getText() + "\" ...");
        try {
            Desktop.getDesktop().open(path);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Cannot access to " + path, "alert", 0);
        }
    }

    private void SelectProject(ActionEvent ev) {
        JTable chooserTable = dgt.lib.SwingUtils.getDescendantsOfType(JTable.class, this.dirChooser).get(0);
        chooserTable.getRowSorter().toggleSortOrder(3);
        chooserTable.getRowSorter().toggleSortOrder(3);
        TableColumn col0 = chooserTable.getColumnModel().getColumn(0);
        col0.setPreferredWidth(col0.getPreferredWidth() + 100);
        if (this.dirChooser.showOpenDialog(this) == 0) {
            File selected = this.dirChooser.getSelectedFile();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(selected, "omegat.project"))));){
                String line;
                while ((line = reader.readLine()) != null) {
                    int idx = line.indexOf("<source_lang>");
                    if (idx >= 0) {
                        line = line.substring(idx + 13);
                        line = line.substring(0, 2);
                        this.mainWindow.srcBox.setSelectedItem(line.toUpperCase());
                    }
                    if ((idx = line.indexOf("<target_lang>")) < 0) continue;
                    line = line.substring(idx + 13);
                    line = line.substring(0, 2);
                    this.mainWindow.traBox.setSelectedItem(line.toUpperCase());
                }
            }
            catch (FileNotFoundException fnf) {
                JOptionPane.showMessageDialog(null, this.dirChooser.getSelectedFile() + " is not a valid OmegaT Project !", "alert", 0);
                return;
            }
            catch (Exception eOther) {
                JOptionPane.showMessageDialog(null, eOther.getMessage(), "alert", 0);
                return;
            }
            new File(selected, "Euramis\\sent").mkdirs();
            this.mainWindow.secemOption.setSelected(selected.toString().toUpperCase().contains("_SECEM"));
            this.mainWindow.fdProject.setText(selected.getName());
            this.mainWindow.PERSO_CONFIG.setProperty("project.name", selected.getName());
            try {
                this.mainWindow.PERSO_CONFIG.store(new FileOutputStream("user-config.properties"), "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mainWindow.runOtButton.setBackground(new Color(0, 204, 0));
            this.mainWindow.runOtButton.setEnabled(true);
            this.mainWindow.msgArea.setText("Project has been selected, you could open it now!");
            ((DefaultListModel)this.mainWindow.documentsListBox.getModel()).removeAllElements();
        }
    }

    private void CreateProject(ActionEvent ev) {
        String command = ev.getActionCommand().toLowerCase();
        if (this.mainWindow.documentsListBox.getModel().getSize() < 1) {
            JOptionPane.showMessageDialog(this.mainWindow, "Cannot " + command + " a project with a blank filelist !!!", "alert", 0);
            return;
        }
        if (this.mainWindow.fdProject.getText() == null || this.mainWindow.fdProject.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this.mainWindow, "Cannot " + command + " a 'blank' project !!!", "alert", 0);
            return;
        }
        this.mainWindow.PERSO_CONFIG.setProperty("project.name", this.mainWindow.fdProject.getText());
        try {
            this.mainWindow.PERSO_CONFIG.store(new FileOutputStream("user-config.properties"), "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") == null) {
            JOptionPane.showMessageDialog(this.mainWindow, "Please configure projects path !!!", "alert", 0);
            return;
        }
        File projPathParent = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath"));
        if (this.mainWindow.secemOption.isSelected()) {
            projPathParent = new File(projPathParent, "_Secem");
        }
        File projPath = new File(projPathParent, this.mainWindow.fdProject.getText().trim());
        if (command.equals("create") && projPath.exists()) {
            JOptionPane.showMessageDialog(this.mainWindow, "Project " + projPath.getName() + " exists. Use &Update instead", "alert", 0);
            return;
        }
        if (command.equals("update") && !projPath.exists()) {
            JOptionPane.showMessageDialog(this.mainWindow, "Project " + projPath.getName() + " does not exist. Use &Create instead", "alert", 0);
            return;
        }
        new CreateProjectDialog(this.mainWindow, this, ev, projPath).setVisible(true);
    }

    private void ClearList(ActionEvent ev) {
        ((DefaultListModel)this.mainWindow.documentsListBox.getModel()).clear();
        this.mainWindow.fdProject.setText("");
        this.mainWindow.runOtButton.setBackground(new Color(191, 191, 191));
        this.mainWindow.runOtButton.setEnabled(false);
    }

    protected void Backup(ActionEvent ev) {
        if (this.mainWindow.secemOption.isSelected()) {
            return;
        }
        if (this.mainWindow.fdProject.getText() == null || this.mainWindow.fdProject.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "Cannot backup a 'blank' project !!!", "alert", 0);
            return;
        }
        File path = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + this.mainWindow.fdProject.getText().trim());
        if (!path.exists()) {
            JOptionPane.showMessageDialog(null, "Project '" + this.mainWindow.fdProject.getText() + "' does not exist yet !!!", "alert", 0);
            return;
        }
        new BackupTask(this.mainWindow, this.mainWindow.fdProject.getText().trim(), false).start();
    }

    private void OpenTeambaseWindow(ActionEvent ev) {
        if (this.mainWindow.fdProject.getText() == null || this.mainWindow.fdProject.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "Cannot connect to TeamBase a 'blank' project !!!", "alert", 0);
            return;
        }
        new TeambaseWindow(this.mainWindow).setVisible(true);
    }
}

