/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.openide.awt.Mnemonics;

public class SwingUtils {
    static JButton createButton(Container pane, String label, String tooltip, Rectangle bounds, Color color, ActionListener listener) {
        JButton btn = new JButton(label);
        if (label.contains("&")) {
            Mnemonics.setLocalizedText((AbstractButton)btn, (String)label);
        }
        btn.setActionCommand(label.replace("&", ""));
        pane.add(btn);
        btn.setBounds(bounds);
        if (color != null) {
            btn.setBackground(color);
        }
        if (listener != null) {
            btn.addActionListener(listener);
        }
        btn.setToolTipText(tooltip);
        return btn;
    }

    public static void copyDirectory(File sourceLocation, File targetLocation, boolean erase) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                SwingUtils.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]), erase);
            }
        } else {
            if (targetLocation.exists() && targetLocation.length() == sourceLocation.length() && targetLocation.lastModified() >= sourceLocation.lastModified()) {
                return;
            }
            if (erase) {
                Files.copy(sourceLocation.toPath(), targetLocation.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(sourceLocation.toPath(), targetLocation.toPath(), new CopyOption[0]);
            }
            targetLocation.setLastModified(sourceLocation.lastModified());
        }
    }

    public static void copyDirectoryAndPurge(File sourceLocation, File targetLocation) throws IOException {
        if (!sourceLocation.isDirectory()) {
            Files.copy(sourceLocation.toPath(), targetLocation.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else {
            if (targetLocation.exists()) {
                for (File child : targetLocation.listFiles()) {
                    if (new File(sourceLocation, child.getName()).exists()) continue;
                    SwingUtils.delTree(child);
                }
            }
            SwingUtils.copyDirectory(sourceLocation, targetLocation, true);
        }
    }

    public static void delTree(File f) throws FileNotFoundException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                SwingUtils.delTree(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    public static void RemoveFromJList(JFrame parent, JList<?> theList) {
        int[] selection = theList.getSelectedIndices();
        if (selection == null || selection.length == 0) {
            if (JOptionPane.showConfirmDialog(parent, "No file selected in the list. Remove all?", "Alert", 0) == 0) {
                ((DefaultListModel)theList.getModel()).clear();
            }
        } else if (JOptionPane.showConfirmDialog(parent, "Delete these " + selection.length + " file(s)?", "Alert", 0) == 0) {
            DefaultListModel model = (DefaultListModel)theList.getModel();
            block0: for (int i = model.size() - 1; i >= 0; --i) {
                for (int j : selection) {
                    if (j != i) continue;
                    model.removeElementAt(j);
                    continue block0;
                }
            }
        }
    }

    public static String environment() {
        try {
            Path p = new File(SwingUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).toPath();
            String res = SwingUtils.environment(p.getParent());
            if (!Pattern.compile("-(dev|test|acc|leg|prod)").matcher(res.toLowerCase()).find()) {
                res = res + "-PROD";
            }
            if (!res.contains("(")) {
                return "(" + res + ")";
            }
            return res;
        }
        catch (Exception e) {
            return "(unknown environment)";
        }
    }

    private static String environment(Path p) throws IOException {
        while (p != null) {
            if (p.getFileName().startsWith("OmegaT-")) {
                return p.getFileName().toString().substring(7);
            }
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(p, "ver.*");){
                Iterator<Path> iterator = dirStream.iterator();
                if (iterator.hasNext()) {
                    Path curFile = iterator.next();
                    String string = curFile.getFileName().toString().substring(4);
                    return string;
                }
            }
            p = p.getParent();
        }
        return "unknown environment";
    }

    public static JFrame showLongProcessDialog(JDialog parent, String msg) {
        JFrame runDlg = new JFrame(msg);
        runDlg.setBounds(parent.getX() + 50, parent.getY() + 50, 20 + 10 * msg.length(), 20);
        runDlg.setVisible(true);
        return runDlg;
    }

    static class IntWrapper {
        int val;

        IntWrapper() {
        }
    }
}

