/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.ui;

import dgt.jwizard.ui.JWizard;
import dgt.jwizard.ui.SwingUtils;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openide.awt.Mnemonics;

public class TeambaseWindow
extends JFrame {
    private JWizard mainWindow;
    private JList<String> sharedList;
    private JList<String> projMemList;
    private JList<String> ownMemList;
    private JTextField sharedChoice;
    private JTextField projMemChoice;
    private JTextField ownMemChoice;
    private JButton modeBtn;
    private JButton cModeBtn;

    public TeambaseWindow(JWizard mainWindow) {
        super("TeamBase Memories");
        this.mainWindow = mainWindow;
        this.setIconImage(new ImageIcon(this.getClass().getResource("/dgt/jwizard/ui/smiley-write.png")).getImage());
        this.setBounds(0, 0, 1080, 480);
        this.getContentPane().setLayout(null);
        JLabel lAv = new JLabel("Available shared memories");
        this.getContentPane().add(lAv);
        lAv.setBounds(5, 5, 345, 15);
        this.sharedList = new JList(new DefaultListModel());
        JScrollPane scroll = new JScrollPane(this.sharedList);
        this.getContentPane().add(scroll);
        scroll.setBounds(3, 20, 345, 360);
        this.sharedChoice = new JTextField();
        this.getContentPane().add(this.sharedChoice);
        this.sharedChoice.setBounds(5, 382, 200, 25);
        this.sharedList.addListSelectionListener(ev -> {
            if (this.sharedList.getSelectedIndex() >= 0) {
                this.sharedChoice.setText(this.sharedList.getModel().getElementAt(this.sharedList.getSelectedIndex()));
            }
        });
        this.modeBtn = SwingUtils.createButton(this.getContentPane(), "Re&ad/Write", "", new Rectangle(209, 382, 138, 25), null, ev -> {
            if (this.modeBtn.getText().contains("Write")) {
                this.modeBtn.setText("R&ead");
            } else {
                this.modeBtn.setText("R&ead/Write");
            }
        });
        SwingUtils.createButton(this.getContentPane(), "Connect &To Shared", "", new Rectangle(5, 412, 343, 25), null, this::Connect);
        TreeSet<String> ownedMemoriesSet = new TreeSet<String>();
        try {
            Pattern PTN_NAME = Pattern.compile("name='(.+?)'");
            Pattern PTN_OWN = Pattern.compile("is-owner='true'");
            DefaultListModel model = (DefaultListModel)this.sharedList.getModel();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(this.buildUrl("list", this.sharedChoice)).openStream()));
            Object object = null;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher m = PTN_NAME.matcher(line);
                    if (m.find()) {
                        model.addElement(m.group(1));
                    }
                    if (!PTN_OWN.matcher(line).find()) continue;
                    ownedMemoriesSet.add(m.group(1).toUpperCase());
                }
            }
            catch (Throwable line) {
                object = line;
                throw line;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable line) {
                            ((Throwable)object).addSuppressed(line);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "get memories:" + e.getClass(), 0);
        }
        JLabel lProjMem = new JLabel("Shared memories linked to my project");
        this.getContentPane().add(lProjMem);
        lProjMem.setBounds(355, 5, 345, 15);
        this.projMemList = new JList(new DefaultListModel());
        scroll = new JScrollPane(this.projMemList);
        this.getContentPane().add(scroll);
        scroll.setBounds(353, 20, 345, 360);
        this.projMemChoice = new JTextField();
        this.getContentPane().add(this.projMemChoice);
        this.projMemChoice.setBounds(355, 382, 200, 25);
        this.projMemChoice.setEditable(false);
        this.projMemList.addListSelectionListener(ev -> {
            if (this.projMemList.getSelectedIndex() >= 0) {
                this.projMemChoice.setText(this.projMemList.getModel().getElementAt(this.projMemList.getSelectedIndex()));
                String projPath = this.memoryFileName(this.projMemList.getModel().getElementAt(this.projMemList.getSelectedIndex()));
                try (FileInputStream fis = new FileInputStream(projPath);){
                    Properties prop = new Properties();
                    prop.load(fis);
                    if (!"false".equalsIgnoreCase(prop.getProperty("update"))) {
                        Mnemonics.setLocalizedText((AbstractButton)this.cModeBtn, (String)"Re&ad/Write");
                    } else {
                        Mnemonics.setLocalizedText((AbstractButton)this.cModeBtn, (String)"R&ead");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.cModeBtn = SwingUtils.createButton(this.getContentPane(), "Re&ad/Write", "", new Rectangle(559, 382, 138, 25), null, ev -> {
            if (this.cModeBtn.getText().contains("Write")) {
                Mnemonics.setLocalizedText((AbstractButton)this.cModeBtn, (String)"R&ead");
            } else {
                Mnemonics.setLocalizedText((AbstractButton)this.cModeBtn, (String)"Re&ad/Write");
            }
            String projPath = this.memoryFileName(this.projMemList.getModel().getElementAt(this.projMemList.getSelectedIndex()));
            try {
                Properties prop = new Properties();
                try (FileInputStream fis = new FileInputStream(projPath);){
                    prop.load(fis);
                }
                prop.setProperty("update", Boolean.toString(this.cModeBtn.getText().contains("Write")));
                var5_6 = null;
                try (FileOutputStream fos = new FileOutputStream(projPath);){
                    prop.store(fos, "");
                }
                catch (Throwable throwable) {
                    var5_6 = throwable;
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        JButton disconnectBtn = SwingUtils.createButton(this.getContentPane(), "Disconnect &From Shared", "", new Rectangle(355, 412, 343, 25), null, this::Disconnect);
        try {
            Path projPath = Paths.get(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + mainWindow.fdProject.getText().trim() + File.separator + "tm", new String[0]);
            String pattern = "*-" + mainWindow.srcBox.getSelectedItem().toString() + "-" + mainWindow.traBox.getSelectedItem().toString() + ".properties";
            DefaultListModel model = (DefaultListModel)this.projMemList.getModel();
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(projPath, pattern);){
                for (Path p : dirStream) {
                    String name = p.getFileName().toString();
                    name = name.substring(0, name.indexOf(46));
                    name = name.substring(0, name.lastIndexOf(45));
                    name = name.substring(0, name.lastIndexOf(45));
                    model.addElement(name);
                }
            }
        }
        catch (NoSuchFileException nsf) {
            ((DefaultListModel)this.projMemList.getModel()).addElement("Project not opened");
            ((DefaultListModel)this.projMemList.getModel()).addElement("(" + mainWindow.fdProject.getText() + ")");
            this.projMemList.setEnabled(false);
            disconnectBtn.setEnabled(false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getClass() + ":\n" + e.getMessage(), "open connections list:alert", 0);
        }
        JLabel lOwnMem = new JLabel("Shared memories I own");
        this.getContentPane().add(lOwnMem);
        lOwnMem.setBounds(705, 5, 345, 15);
        DefaultListModel<String> ownModel = new DefaultListModel<String>();
        this.ownMemList = new JList(ownModel);
        scroll = new JScrollPane(this.ownMemList);
        this.getContentPane().add(scroll);
        scroll.setBounds(703, 20, 345, 360);
        for (String mem : ownedMemoriesSet) {
            ownModel.addElement(mem);
        }
        this.ownMemChoice = new JTextField();
        this.getContentPane().add(this.ownMemChoice);
        this.ownMemChoice.setBounds(705, 382, 345, 25);
        this.ownMemChoice.setEditable(false);
        this.ownMemList.addListSelectionListener(ev -> {
            if (this.ownMemList.getSelectedIndex() >= 0) {
                this.ownMemChoice.setText(this.ownMemList.getModel().getElementAt(this.ownMemList.getSelectedIndex()));
            }
        });
        SwingUtils.createButton(this.getContentPane(), "&Delete shared memory", "", new Rectangle(705, 412, 343, 25), null, this::Delete);
    }

    private String memoryFileName(String memoryName) {
        return this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + this.mainWindow.fdProject.getText().trim() + File.separator + "tm" + File.separator + memoryName + "-" + this.mainWindow.srcBox.getSelectedItem().toString() + "-" + this.mainWindow.traBox.getSelectedItem().toString() + ".properties";
    }

    private String buildUrl(String cmd, JTextField nameField) {
        String url = this.mainWindow.GLOBAL_CONFIG.getProperty("teambase.memrest.server") + this.mainWindow.GLOBAL_CONFIG.getProperty("teambase.memrest.command." + cmd);
        url = url.replace("$src$", this.mainWindow.srcBox.getSelectedItem().toString()).replace("$tra$", this.mainWindow.traBox.getSelectedItem().toString());
        url = url.replace("$projname$", nameField.getText());
        return url;
    }

    private void Connect(ActionEvent ev) {
        try {
            this.ConnectToSelected();
        }
        catch (Exception e) {
            try {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(this.buildUrl("createdb", this.sharedChoice)).openStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        Matcher m;
                        if (!line.contains("failed") || !(m = Pattern.compile("cause\\s*=\\s*(\\W)(.+)\\1").matcher(line)).find()) continue;
                        throw new Exception(m.group(2));
                    }
                }
                ((DefaultListModel)this.ownMemList.getModel()).addElement(this.sharedChoice.getText().toUpperCase());
                this.ConnectToSelected();
            }
            catch (Exception e2) {
                JOptionPane.showMessageDialog(null, e2.getMessage(), "connect:alert", 0);
            }
        }
    }

    private void ConnectToSelected() throws Exception {
        String url = this.buildUrl("OmegaT-tm", this.sharedChoice);
        url = url.replace("update=true", "update=" + Boolean.toString(this.modeBtn.getText().contains("Write")));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));){
            String projPath = this.memoryFileName(this.sharedChoice.getText());
            try (PrintWriter out = new PrintWriter(new FileOutputStream(projPath));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("project not found")) {
                        throw new Exception("Memory does not exist");
                    }
                    out.println(line);
                }
            }
            File f = new File(projPath);
            if (f.length() == 0L) {
                f.delete();
                throw new Exception("Could not build OmegaT file, maybe memory does not exist");
            }
        }
        if (!((DefaultListModel)this.projMemList.getModel()).contains(this.sharedChoice.getText())) {
            ((DefaultListModel)this.projMemList.getModel()).addElement(this.sharedChoice.getText());
        }
    }

    private void Disconnect(ActionEvent ev) {
        if (this.projMemChoice.getText() == null) {
            return;
        }
        if (this.projMemChoice.getText().trim().length() == 0) {
            return;
        }
        try {
            File f = new File(this.memoryFileName(this.projMemChoice.getText()));
            boolean exist = f.exists();
            f.delete();
            if (exist) {
                this.mainWindow.msgArea.setText("Disconnected from TeamBase memory " + this.projMemChoice.getText());
            }
            ((DefaultListModel)this.projMemList.getModel()).removeElement(this.projMemChoice.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getClass() + ":" + e.getMessage(), "disconnect:alert", 0);
            e.printStackTrace();
        }
    }

    private void Delete(ActionEvent ev) {
        if (this.ownMemChoice.getText() == null) {
            return;
        }
        if (this.ownMemChoice.getText().trim().length() == 0) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(this.buildUrl("dropdb", this.ownMemChoice)).openStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher m;
                if (!line.contains("failed") || !(m = Pattern.compile("cause\\s*=\\s*(\\W)(.+)\\1").matcher(line)).find()) continue;
                throw new Exception(m.group(2));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "alert", 0);
        }
        this.projMemChoice.setText(this.ownMemChoice.getText());
        this.Disconnect(ev);
        ((DefaultListModel)this.sharedList.getModel()).removeElement(this.ownMemChoice.getText());
        ((DefaultListModel)this.projMemList.getModel()).removeElement(this.ownMemChoice.getText());
        ((DefaultListModel)this.ownMemList.getModel()).removeElement(this.ownMemChoice.getText());
    }
}

