/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.act;

import dgt.jwizard.ui.JWizard;
import dgt.jwizard.ui.SwingUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BackupTask
extends Thread {
    public static final Pattern DGT_PROJ = Pattern.compile("(\\w+)-(\\d{4}-\\d{5})(-\\d{2})?(-\\d{2})?");
    private final JWizard mainWindow;
    private final String projName;
    public boolean active = true;
    public int interval = 1800000;

    public BackupTask(JWizard wizard, String projName, boolean active) {
        this.mainWindow = wizard;
        this.projName = projName;
        this.active = active;
    }

    @Override
    public void run() {
        while (this.active) {
            try {
                Thread.sleep(this.interval);
                if (!this.active) continue;
                this.BackupProject();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.BackupProject();
    }

    private void BackupProject() {
        this.mainWindow.msgArea.setText("Storing Project '" + this.projName + "' to '" + this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsBkpPath") + "' ...\n");
        File path = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + this.projName);
        try {
            if (!this.active && this.mainWindow.GLOBAL_CONFIG.getProperty("exe.roboCopy") != null) {
                CharSequence[] roboCall = new String[]{this.mainWindow.GLOBAL_CONFIG.getProperty("exe.roboCopy"), path.toString(), this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsBkpPath") + File.separator + this.projName, "*.*", "/np", "/r:10", "/w:0", "/e"};
                Process proc = Runtime.getRuntime().exec((String[])roboCall);
                proc.getInputStream().close();
                this.mainWindow.msgArea.append(String.join((CharSequence)" ", roboCall) + "\n");
                try (BufferedReader is = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
                    String line;
                    while ((line = is.readLine()) != null) {
                        this.mainWindow.msgArea.append(line);
                    }
                }
            } else {
                SwingUtils.copyDirectory(path, new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsBkpPath") + File.separator + this.projName), true);
            }
            this.mainWindow.msgArea.append("\nProject '" + this.projName + "' has been stored to '" + this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsBkpPath") + "'");
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            this.mainWindow.msgArea.append(e.getClass().getName() + ": " + e.getMessage());
        }
        try {
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(path.toString() + File.separator + "source", new String[0]), "*.*");){
                File projectSave = new File(path, "OmegaT" + File.separator + "project_save.tmx");
                int i = 1;
                for (Path p : dirStream) {
                    Matcher mProj = DGT_PROJ.matcher(p.toFile().getName());
                    if (!mProj.find()) continue;
                    String dossiersPath = this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator;
                    dossiersPath = dossiersPath + mProj.group(1) + File.separator + mProj.group(1) + "-" + mProj.group(2) + File.separator + "pret";
                    dossiersPath = dossiersPath + File.separator + mProj.group() + "-DRAFT-" + System.getProperty("user.name") + ".tmx";
                    Files.copy(projectSave.toPath(), Paths.get(dossiersPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    this.mainWindow.msgArea.append("\n" + i++ + " - project_save.tmx saved as " + dossiersPath);
                }
            }
            Thread.sleep(1000L);
            this.mainWindow.msgArea.append("\nBackup done!");
        }
        catch (Exception e) {
            this.mainWindow.msgArea.append(e.getClass().getName() + ": " + e.getMessage());
        }
    }
}

