/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.ui;

import dgt.jwizard.ui.JWizard;
import dgt.jwizard.ui.SwingUtils;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;

public class PanelRevision
extends JPanel {
    private JWizard mainWindow;
    protected SubPanel panRevTranslator;
    protected SubPanel panRevRevisor;
    private static final Color BTN_COLOR = null;
    private static final String SECEM_UUID = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}";

    public PanelRevision(JWizard mainWindow) {
        this.mainWindow = mainWindow;
        this.setBorder(new TitledBorder("REVISION"));
        this.setLayout(null);
        this.setBackground(JWizard.DEFAULT_BACKGROUND);
        this.panRevTranslator = new SubPanel("Translator");
        this.add(this.panRevTranslator);
        this.panRevTranslator.setBounds(8, 18, 125, 150);
        this.panRevTranslator.createButton("Send", "Send project to reviser", ev -> this.SendToRevisor());
        this.panRevTranslator.createButton("Get", "Select a revised project", ev -> this.DoGet("Choose a Revised Project", "Revised"));
        this.panRevTranslator.createButton("Browse", "Browse projects to be revised", ev -> this.BrowsePath("ToRevise"));
        this.panRevRevisor = new SubPanel("Reviser");
        this.add(this.panRevRevisor);
        this.panRevRevisor.setBounds(8, 168, 125, 150);
        this.panRevRevisor.createButton("Get", "Select a project to revise", ev -> this.DoGet("Choose a Project to revise", "ToRevise"));
        this.panRevRevisor.createButton("Send", "Send a revised project", ev -> this.SendRevised());
        this.panRevRevisor.createButton("Browse", "Browse revised projects", ev -> this.BrowsePath("Revised"));
    }

    private void BrowsePath(String pathName) {
        String path = this.mainWindow.GLOBAL_CONFIG.getProperty("Paths." + pathName);
        if (this.mainWindow.secemOption.isSelected()) {
            path = path + SECEM_UUID;
        }
        try {
            Desktop.getDesktop().open(new File(path));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Cannot access to " + path, "alert", 0);
        }
    }

    private void DoGet(String dialogTitle, String baseDir) {
        String SECEM = "";
        if (this.mainWindow.secemOption.isSelected()) {
            SECEM = SECEM_UUID;
        }
        JFileChooser dirChooser = new JFileChooser(new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths." + baseDir) + SECEM));
        dirChooser.setFileSelectionMode(1);
        dirChooser.setDialogTitle(dialogTitle);
        if (dirChooser.showOpenDialog(this) == 0) {
            File selected = dirChooser.getSelectedFile();
            if (!new File(selected, "omegat.project").exists()) {
                JOptionPane.showMessageDialog(null, dirChooser.getSelectedFile() + " is not a valid OmegaT Project !", "alert", 0);
                return;
            }
            this.mainWindow.msgArea.setText("Getting " + selected + " ... ");
            try {
                File dest = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + selected.getName());
                SwingUtils.copyDirectory(selected, dest, true);
                this.mainWindow.fdProject.setText(dest.getName());
                this.mainWindow.msgArea.setText("Now you can open the Project " + dest.getName());
            }
            catch (Exception e) {
                this.mainWindow.msgArea.setText(e.getMessage());
            }
        }
    }

    private void SendRevised() {
        String fromDir = this.mainWindow.fdProject.getText();
        String toDir = fromDir.replaceAll("_For-Revision-\\w{7}", "_Revised-" + System.getProperty("user.name"));
        toDir = JOptionPane.showInputDialog(this, "Project Name", toDir);
        String SECEM = "";
        if (this.mainWindow.secemOption.isSelected()) {
            SECEM = SECEM_UUID;
        }
        JFileChooser dirChooser = new JFileChooser(new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.Revised") + SECEM));
        dirChooser.setFileSelectionMode(1);
        dirChooser.setDialogTitle("Choose a dir where put the Project");
        if (dirChooser.showOpenDialog(this) == 0) {
            File selected = dirChooser.getSelectedFile();
            this.mainWindow.msgArea.setText("Sending Project " + fromDir + " to " + toDir + " for Revision ... ");
            try {
                File src = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + fromDir);
                if (!src.exists()) {
                    throw new Exception("Project " + fromDir + " not found");
                }
                SwingUtils.copyDirectory(src, new File(selected, toDir), true);
                this.mainWindow.msgArea.append("\nProject " + fromDir + " for Revision sent ...");
            }
            catch (Exception e) {
                this.mainWindow.msgArea.append("\n" + e.getClass() + ":" + e.getMessage());
            }
        }
    }

    private void SendToRevisor() {
        File projDir = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + this.mainWindow.fdProject.getText().trim());
        File destDir = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.ToRevise"));
        File projFile = new File(projDir, "omegat.project");
        if (this.mainWindow.secemOption.isSelected() && !projFile.exists()) {
            JOptionPane.showMessageDialog(null, "SECEM project do not exist!", "alert", 0);
            return;
        }
        if (projFile.length() < 1L) {
            JOptionPane.showMessageDialog(null, "Cannot send for Revision the opened " + this.mainWindow.fdProject.getText() + " project!", "alert", 0);
            return;
        }
        final File omegaTexport = new File(projDir, "export-omegat");
        omegaTexport.mkdirs();
        final File projectSave = new File(projDir, "omegat");
        if (!projectSave.exists()) {
            JOptionPane.showMessageDialog(null, "Omegat_save not found!", "alert", 0);
            return;
        }
        final DefaultListModel<Path> aOmegaTexport = new DefaultListModel<Path>();
        final DefaultListModel<Path> aProjectSave = new DefaultListModel<Path>();
        try {
            Path streamPath = omegaTexport.toPath();
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(streamPath, "*.tmx");){
                for (Path p : dirStream) {
                    aOmegaTexport.addElement(streamPath.relativize(p));
                }
            }
            streamPath = projectSave.toPath();
            dirStream = Files.newDirectoryStream(streamPath, "*.tmx");
            var10_11 = null;
            try {
                for (Path p : dirStream) {
                    aProjectSave.addElement(streamPath.relativize(p));
                }
            }
            catch (Throwable throwable) {
                var10_11 = throwable;
                throw throwable;
            }
            finally {
                if (dirStream != null) {
                    if (var10_11 != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable) {
                            var10_11.addSuppressed(throwable);
                        }
                    } else {
                        dirStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getClass().getName() + ":" + e.getMessage(), "alert", 0);
            return;
        }
        this.mainWindow.msgArea.setText("" + aOmegaTexport.size() + " file(s) will be sent.");
        JDialog sendDlg = new JDialog((Frame)this.mainWindow, false);
        sendDlg.setBounds(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2, 740, 390);
        sendDlg.getContentPane().setLayout(null);
        sendDlg.setBackground(JWizard.DEFAULT_BACKGROUND);
        JTextField iDir = new JTextField();
        sendDlg.getContentPane().add(iDir);
        iDir.setBounds(20, 20, 700, 25);
        iDir.setToolTipText("Revision Project Name");
        iDir.setText(this.mainWindow.fdProject.getText() + "_For-Revision-" + System.getProperty("user.name"));
        JButton bDir = new JButton(destDir.toString());
        sendDlg.getContentPane().add(bDir);
        bDir.setBounds(20, 50, 700, 25);
        bDir.setToolTipText("Click to change Destination Folder");
        bDir.addActionListener(ev -> {
            JFileChooser dirChooser = new JFileChooser(destDir);
            dirChooser.setFileSelectionMode(1);
            dirChooser.setDialogTitle("Select Destination Folder");
            if (dirChooser.showOpenDialog(this) == 0) {
                bDir.setText(dirChooser.getSelectedFile().toString());
            }
        });
        final JList fileList = new JList(new DefaultListModel());
        sendDlg.getContentPane().add(fileList);
        fileList.setBounds(20, 110, 700, 175);
        final JLabel lblSize = new JLabel("" + aOmegaTexport.size() + " file(s) will be sent.");
        sendDlg.getContentPane().add(lblSize);
        lblSize.setBounds(80, 290, 300, 25);
        fileList.addListSelectionListener(ev -> {
            String msg = "" + fileList.getSelectedIndices().length + " file(s) will be sent.";
            lblSize.setText(msg);
            this.mainWindow.msgArea.setText(msg);
        });
        class SwitchButton
        extends JButton
        implements ActionListener {
            boolean sTMX;
            File tmxDir;
            DefaultListModel<Path> aArray;

            public SwitchButton() {
                this.sTMX = !omegaTexport.exists() || omegaTexport.listFiles().length <= 0;
                this.tmxDir = this.sTMX ? projectSave : omegaTexport;
                this.aArray = this.sTMX ? aProjectSave : aOmegaTexport;
                this.addActionListener(this);
                this.setLabel(this.tmxDir.toString());
                fileList.setModel(this.aArray);
                this.setToolTipText(this.sTMX ? "Click to switch Project Save" : "Click to switch OmegaT Export Folder");
                if (this.sTMX) {
                    this.setEnabled(false);
                    this.setToolTipText("OmegaT Export folder is empty, cannot change unless you run create-euramis-export script");
                }
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (this.sTMX) {
                    this.sTMX = false;
                    this.tmxDir = omegaTexport;
                    this.aArray = aOmegaTexport;
                    if (aOmegaTexport.isEmpty()) {
                        String msg = "No files found in Omegat_Export!";
                        lblSize.setText(msg);
                        ((PanelRevision)PanelRevision.this).mainWindow.msgArea.setText(msg);
                        return;
                    }
                } else {
                    this.sTMX = true;
                    this.tmxDir = projectSave;
                    this.aArray = aProjectSave;
                    if (aProjectSave.isEmpty()) {
                        String msg = "Project_save.tmx not found in OmegaT!";
                        lblSize.setText(msg);
                        ((PanelRevision)PanelRevision.this).mainWindow.msgArea.setText(msg);
                        return;
                    }
                }
                fileList.setModel(this.aArray);
                this.setLabel(this.tmxDir.toString());
                String msg = "" + this.aArray.getSize() + " file(s) to be sent";
                lblSize.setText(msg);
                ((PanelRevision)PanelRevision.this).mainWindow.msgArea.setText(msg);
                this.setToolTipText(this.sTMX ? "Click to switch Project Save" : "Click to switch OmegaT Export Folder");
            }
        }
        SwitchButton bExport = new SwitchButton();
        sendDlg.getContentPane().add(bExport);
        bExport.setBounds(20, 80, 700, 25);
        JButton btnSend = new JButton("Send");
        JButton btnCancel = new JButton("Cancel");
        sendDlg.getContentPane().add(btnCancel);
        btnCancel.setBounds(620, 320, 100, 25);
        btnCancel.addActionListener(ev -> {
            this.mainWindow.msgArea.setText("");
            sendDlg.setVisible(false);
        });
        sendDlg.getContentPane().add(btnSend);
        btnSend.setBounds(20, 320, 100, 25);
        btnSend.addActionListener(ev -> {
            JFrame longProc;
            PrintStream log;
            block26: {
                String msg = "Sending Project " + iDir.getText() + " for Revision ...\n";
                lblSize.setText(msg);
                this.mainWindow.msgArea.setText(msg);
                try {
                    log = new PrintStream(new File(projDir, "wizard-sendToRevisor.log"));
                }
                catch (Exception e) {
                    log = System.err;
                }
                longProc = SwingUtils.showLongProcessDialog(sendDlg, msg);
                try {
                    if (this.mainWindow.GLOBAL_CONFIG.getProperty("exe.roboCopy") != null) {
                        CharSequence[] roboCall = new String[]{this.mainWindow.GLOBAL_CONFIG.getProperty("exe.roboCopy"), projDir.toString(), bDir.getText() + File.separator + iDir.getText(), "*.*", "/np", "/r:10", "/w:0", "/e", "/mir"};
                        Process proc = Runtime.getRuntime().exec((String[])roboCall);
                        proc.getInputStream().close();
                        log.println(System.currentTimeMillis() + " : JWizard " + "2.5.3");
                        log.println(String.join((CharSequence)" ", roboCall) + "\n");
                        BufferedReader is = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        Object object = null;
                        try {
                            String line;
                            while ((line = is.readLine()) != null) {
                                log.println(line);
                            }
                        }
                        catch (Throwable line) {
                            object = line;
                            throw line;
                        }
                        finally {
                            if (is != null) {
                                if (object != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable line) {
                                        ((Throwable)object).addSuppressed(line);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                        log.println(System.currentTimeMillis() + " : Robocopy finished");
                        break block26;
                    }
                    SwingUtils.copyDirectoryAndPurge(projDir, new File(bDir.getText(), iDir.getText()));
                }
                catch (Exception e) {
                    log.println("Error: \n");
                    e.printStackTrace(log);
                    JOptionPane.showMessageDialog(sendDlg, e.getClass().getName() + " : " + e.getMessage(), "alert", 0);
                    return;
                }
            }
            this.mainWindow.msgArea.append("Distant directory created\n");
            log.println("Distant directory created\n");
            File destProjDir = new File(bDir.getText() + File.separator + iDir.getText());
            File draftPath = new File(destProjDir, "tm" + File.separator + "auto" + File.separator + "draft");
            draftPath.mkdirs();
            File otDir = new File(destProjDir, "omegat");
            if (bExport.sTMX) {
                this.copyWithLog(new File(otDir, "project_save.tmx"), new File(draftPath, "project_save.tmx"), log);
            } else {
                List selection = fileList.getSelectedValuesList();
                if (selection.isEmpty()) {
                    ListModel model = fileList.getModel();
                    selection = new ArrayList(model.getSize());
                    for (int i = 0; i < model.getSize(); ++i) {
                        selection.add(model.getElementAt(i));
                    }
                }
                File exportDir = new File(destProjDir, "export-omegat");
                File preProc = new File(exportDir, "processed");
                preProc.mkdirs();
                for (Path p : selection) {
                    File export = new File(exportDir, p.toFile().getName());
                    this.copyWithLog(export, new File(draftPath, p.toFile().getName()), log);
                    export.renameTo(new File(preProc, export.getName()));
                }
            }
            for (File f : new File(destProjDir, "omegat").listFiles()) {
                if (f.getName().startsWith("last_entry.")) {
                    f.delete();
                    continue;
                }
                if (!f.getName().contains(".tmx.")) continue;
                f.delete();
            }
            log.println("Project " + iDir.getText() + " for Revision sent ...");
            log.close();
            this.mainWindow.msgArea.append("Project " + iDir.getText() + " for Revision sent ...");
            sendDlg.setVisible(false);
            longProc.setVisible(false);
        });
        sendDlg.setVisible(true);
    }

    private void copyWithLog(File src, File dest, PrintStream log) {
        this.mainWindow.msgArea.append("Copy " + src + " to " + dest);
        log.print("Copy " + src + " to " + dest);
        try {
            Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.mainWindow.msgArea.append(" --> OK\n");
            log.println(" -> OK");
        }
        catch (Exception e) {
            this.mainWindow.msgArea.append(" --> Failed (see log)");
            log.println(" --> Failed");
            e.printStackTrace(log);
        }
    }

    protected class SubPanel
    extends JPanel {
        private int y = -12;
        private JLabel flagSecem = new JLabel("SECEM");

        private SubPanel(String title) {
            this.setBorder(new TitledBorder(title));
            this.setLayout(null);
            this.setBackground(JWizard.DEFAULT_BACKGROUND);
            this.flagSecem.setBounds(40, 112, 95, 25);
            this.add(this.flagSecem);
            this.toggleSecem();
            this.flagSecem.setFont(new Font(this.flagSecem.getFont().getName(), 0, 15));
            this.flagSecem.setForeground(Color.red);
        }

        private JButton createButton(String label, String tooltip, ActionListener listener) {
            this.y += 30;
            return SwingUtils.createButton(this, label.trim(), tooltip, new Rectangle(10, this.y, 95, 25), BTN_COLOR, listener);
        }

        public final void toggleSecem() {
            this.flagSecem.setVisible(((PanelRevision)PanelRevision.this).mainWindow.secemOption.isSelected());
        }
    }
}

