/*
 * Decompiled with CFR 0.152.
 */
package dgt.lib;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Base64;
import java.util.Map;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class SoapCall {
    private final String service_url;
    private final String namespace_uri;
    private final String user;
    private final String pass;

    public SoapCall(String namespace_uri, String service_url) {
        this.namespace_uri = namespace_uri;
        this.service_url = service_url;
        this.pass = null;
        this.user = null;
    }

    public SoapCall(String namespace_uri, String service_url, String user, String pass) {
        this.namespace_uri = namespace_uri;
        this.service_url = service_url;
        this.user = user;
        this.pass = pass;
    }

    public Document call(String command, Map<String, Object> xmlParams, PrintWriter log) throws Exception {
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = soapConnectionFactory.createConnection();
        SOAPMessage res = soapConnection.call(this.createSOAPRequest(command, xmlParams, log), (Object)this.service_url);
        if (res.getSOAPBody().hasFault()) {
            throw new Exception("SOAP fault: " + res.getSOAPBody().getFault().getFaultString());
        }
        return res.getSOAPBody().extractContentAsDocument();
    }

    private void createSubElements(SOAPElement dest, Map<String, Object> xmlParams) throws SOAPException {
        for (Map.Entry<String, Object> entry : xmlParams.entrySet()) {
            SOAPElement ref = dest.addChildElement(entry.getKey());
            if (entry.getValue() instanceof String) {
                ref.addTextNode(entry.getValue().toString());
            }
            if (!(entry.getValue() instanceof Map)) continue;
            this.createSubElements(ref, (Map)entry.getValue());
        }
    }

    public static String findElementContent(Document doc, String name) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (name.contains("|")) {
            for (String name0 : name.split("\\|")) {
                String res = SoapCall.findElementContent(doc, name0);
                if (res == null || res.length() <= 0) continue;
                return res;
            }
            return "";
        }
        return xpath.evaluate("//" + name, doc, XPathConstants.STRING).toString();
    }

    public static void dump(Document doc, PrintWriter res) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(new DOMSource(doc), new StreamResult(res));
        res.println("");
    }

    public static void dump(Document doc, PrintStream res) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(new DOMSource(doc), new StreamResult(res));
        res.println("");
    }

    private SOAPMessage createSOAPRequest(String command, Map<String, Object> xmlParams, PrintWriter log) throws SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        envelope.addNamespaceDeclaration("eu", this.namespace_uri);
        SOAPBody soapBody = envelope.getBody();
        SOAPElement commandElement = soapBody.addChildElement(command, "eu");
        this.createSubElements(commandElement, xmlParams);
        if (this.user != null) {
            String authorization = this.user + ":" + this.pass;
            authorization = Base64.getEncoder().encodeToString(authorization.getBytes());
            soapMessage.getMimeHeaders().addHeader("Authorization", "Basic " + authorization);
        }
        soapMessage.saveChanges();
        if (log != null) {
            try {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                soapMessage.writeTo((OutputStream)bOut);
                String st = bOut.toString();
                if (st.length() < 4096) {
                    log.println("SOAP Message (size = " + st.length() + ") : " + st);
                } else {
                    log.println("SOAP Message (size = " + st.length() + ") : " + st.substring(0, st.indexOf("<file>") + 20) + "[...]" + st.substring(st.indexOf("</file>") - 20));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return soapMessage;
    }
}

