#!/bin/bash

MISSING=""
which perl >/dev/null 2> /dev/null || MISSING="$MISSING perl"
which realpath >/dev/null 2> /dev/null || MISSING="$MISSING realpath"
which zip >/dev/null 2> /dev/null || MISSING="$MISSING zip"
which unzip >/dev/null 2> /dev/null || MISSING="$MISSING unzip"
which bash >/dev/null 2> /dev/null || MISSING="$MISSING bash"
which kaptain >/dev/null 2> /dev/null || MISSING="$MISSING kaptain"



if [ $MISSING ]; then
    # Try to find which istaller to use. The list can be completed later
    if (which apt-get > /dev/null 2> /dev/null) ; then           # Debian, Ubuntu, Mint, etc.
        INSTALL_CMD="apt-get -y install"
    elif (which yum > /dev/null 2> /dev/null) ; then             # Red Hat, Fedora, CentOs, etc.
        INSTALL_CMD="yum -y install"
    elif (which urpmi > /dev/null 2> /dev/null) ; then             # Mageia, OpenMandriva, Mandriva
        INSTALL_CMD="urpmi"
    elif (which pacman > /dev/null 2> /dev/null) ; then             # Arch Linux / Arch Hurd
        INSTALL_CMD="pacman -S"
    elif (which pkg_add > /dev/null 2> /dev/null) ; then             # *BSD old method
        INSTALL_CMD="pkg_add -r"
    elif (which pkg > /dev/null 2> /dev/null) ; then             # *BSD new method, Solaris PC 
        INSTALL_CMD="pkg install"
    elif [[ "$OSTYPE" == "darwin"* ]]; then			# Mac OS
        if (which brew > /dev/null 2> /dev/null) ; then
            echo "Mac OS detected, with brew installed"
        else
            /usr/bin/ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)"
        fi
        INSTALL_CMD="brew install"
    else
        echo "Could not find which installer tool your OS uses."
        echo "Following packages must be installed : $MISSING"
        echo "Please install them and start this script again."
        exit
    fi

    for i in `echo $MISSING` ; do
        if (sudo -c "$INSTALL_CMD $i") ; then
            echo "Installed $i"
        else    # User is not in /etc/sudoers           
            echo "Admin rights are temporarly required to install $i"
            echo "Type root password to continue, or exit and ask your administrator to install $i"
            su root -c "$INSTALL_CMD $i"
            echo "Installed $i"
        fi
    done
fi

MY_PATH="`dirname \"$0\"`"
cd "$MY_PATH"

rm -rf $HOME/bin/tagwipe
mkdir -p $HOME/bin/tagwipe

cp ./tagwipe.* $HOME/bin/tagwipe
cp level.* $HOME/bin/tagwipe
cp inplace.* $HOME/bin/tagwipe

chmod +x $HOME/bin/tagwipe/tagwipe.sh

if [ -e $HOME/.config/user-dirs.dirs ] ; then
    . $HOME/.config/user-dirs.dirs
elif [ -e $HOME/Desktop ] ; then
    XDG_DESKTOP_DIR="$HOME/Desktop"
else
    echo "Your environment does not seem to be a GUI."
    echo "Desktop icon will not be installed. Exit."
    exit
fi
 
echo "
[Desktop Entry]
Type=Application
Terminal=true
Icon=true
Exec=$HOME/bin/tagwipe/tagwipe.sh
Name=Tagwipe Drag&Drop
Categories=Utility;
" > $XDG_DESKTOP_DIR/Tagwipe-DragDrop.desktop
chmod +x $XDG_DESKTOP_DIR/Tagwipe-DragDrop.desktop
 
# Kaptain version : only if we succeeded to install Kaptain
if ( which kaptain >/dev/null 2> /dev/null ) ; then
   cp tagwipe-gui.desktop $XDG_DESKTOP_DIR
   chmod +x $XDG_DESKTOP_DIR/tagwipe-gui.desktop	
fi
 
