#! /usr/bin/env bash

# version 20170814-beta

if [ "$1" = "" ]
  then 
  echo Use: 
  echo TagWipe full_path_file.docx
  echo or drag and drop on Tagwipe shortcut
  read -rsp $'\nPress enter to continue...\n'	
  exit 0
fi

wipe () {
clear

CURR=$(pwd)

##### shell vars
SH=$(realpath "$0")
SHPATH=$(dirname "$SH")
SHNAME=$(basename "$SH")
SHNAME=${SHNAME%.*}
SHEXT=${SH##*.}

#####  file vars
FILE=$(realpath "$1")
FILEPATH=$(dirname "$FILE")
FILENAME=$(basename "$FILE")
FILENAME=${FILENAME%.*}
FILEEXT=${FILE##*.}

##### level of cleaning
LEVEL=$(ls "$SHPATH"/level*) 
LEVEL=${LEVEL##*.}; export LEVEL

INPLACE=$(ls "$SHPATH"/inplace*) 
INPLACE=${INPLACE##*.}

# set BEAUTY=1 only have more readeable XML
# do not set to 1 if used with OmegaT
BEAUTY=0 ; export BEAUTY 

mkdir "/tmp/$FILENAME"
cd "/tmp/$FILENAME"

echo Exploding $FILENAME.$FILEEXT ...
unzip -q -o "$FILE"

# only endnotes, footnotes and document are processed
for i in `find . | egrep -i "(endnotes|foot.+?|document).xml$" `
 do 
  echo Cleaning $i ...
  perl "$SHPATH/tagwipe.pl" $i
 done

mkdir "$FILEPATH/$INPLACE" 
echo Imploding $FILENAME$INPLACE.$FILEEXT ...
zip -5 -q -r "$FILEPATH/$INPLACE/$FILENAME.$FILEEXT" .

cd $CURR
rm -r "/tmp/$FILENAME"

}

shopt -s nocasematch

for i in  "$@"  ;do
	FILE=$(realpath "$i")
	EXT=${FILE##*.}

	if [ -f "$FILE"  ]  && [[ ${EXT} == "DOCX" ]] ; then
		wipe "$FILE"
	fi
done

exit 1
