/**************************************************************************
 This is a plugin adding a toolbar in Omega-T (http://www.omegat.org/)
 This works for Omega-T (http://www.omegat.org/) as well as DGT-Omega-T
 
 Copyright (C) 2012-2017 Thomas Cordonnier for European Commission (Thomas.Cordonnier@ext.ec.europa.eu)

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *************************************************************************/
 
package org.omegat.gui.main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.BorderLayout;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.JToolBar;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import javax.swing.JButton;
import javax.swing.text.Highlighter.HighlightPainter;

import org.omegat.util.Log;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.util.OStrings;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.Collections;
import java.util.List;
import java.net.URL;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ToolBar extends javax.swing.JToolBar implements ActionListener, IMarker, IProjectEventListener /* Bogus plugin type */ {

    private static final Logger LOGGER = Logger.getLogger(ToolBar.class.getName());
	
	public static ToolBar INSTANCE = null;
	
    /** MainWindow menu handler instance. */
    protected final MainWindowMenuHandler mainWindowMenuHandler;

	public ToolBar() {
		this ((MainWindow) Core.getMainWindow());
	}
	
	public ToolBar (MainWindow parent) {
		addJToolBarButton (parent.menu, "projectNewMenuItem", "TF_MENU_FILE_CREATE", "filenew.png");
		addJToolBarButton (parent.menu, "projectOpenMenuItem", "TF_MENU_FILE_OPEN", "project_open.png");
		addJToolBarButton (parent.menu, "projectReloadMenuItem", "TF_MENU_PROJECT_RELOAD", "reload.png");
		addJToolBarButton (parent.menu, "projectCloseMenuItem", "TF_MENU_FILE_CLOSE", "fileclose.png");
		addSeparator();
		addJToolBarButton (parent.menu, "editUndoMenuItem", "TF_MENU_EDIT_UNDO", "undo.png");
		addJToolBarButton (parent.menu, "editRedoMenuItem", "TF_MENU_EDIT_REDO", "redo.png");
		addSeparator();
		addJToolBarButton (parent.menu, "editFindInProjectMenuItem", "TF_MENU_EDIT_FIND,TF_MENU_EDIT_FIND_PROJECT", "search.png");
		addJToolBarButton (parent.menu, "editReplaceInProjectMenuItem", "TF_MENU_EDIT_REPLACEALL,TF_MENU_EDIT_REPLACE", "replaceAll.png");
		addSeparator();
        addJToolBarButton (parent.menu, "gotoPreviousSegmentMenuItem", "TF_MENU_EDIT_PREV", "1uparrow.png");
        addJToolBarButton (parent.menu, "gotoNextSegmentMenuItem", "TF_MENU_EDIT_NEXT", "1downarrow.png");
        addJToolBarButton (parent.menu, "gotoNextUntranslatedMenuItem", "TF_MENU_EDIT_UNTRANS", "2downarrow.png");
        //addJToolBarButton (parent.menu, "gotoSegmentMenuItem", "TF_MENU_EDIT_GOTO", "2rightarrow.png");
		addSeparator();
		addJToolBarButton (parent.menu, "editOverwriteTranslationMenuItem", "TF_MENU_EDIT_RECYCLE", "eraser.png");
		addJToolBarButton (parent.menu, "editInsertTranslationMenuItem", "TF_MENU_EDIT_INSERT", "key_enter.png");
		addJToolBarButton (parent.menu, "editOverwriteMachineTranslationMenuItem", "TF_MENU_EDIT_OVERWRITE_MACHITE_TRANSLATION", "machinetrans.png");		
		addSeparator();
		addJToolBarButton (parent.menu, "editTagPainterMenuItem", "TF_MENU_EDIT_TAGPAINT", "ins_tag.png");
		addJToolBarButton (parent.menu, "toolsValidateTagsMenuItem", "TF_MENU_TOOLS_VALIDATE", "validate_tag.png");
		addJToolBarButton (parent.menu, "revisionModeMenuItem", "TF_MENU_REVISION_MODE", "rev1.png");		
		addSeparator();
		addJToolBarButton (parent.menu, "projectExitMenuItem", "TF_MENU_FILE_QUIT", "application-exit.png");
		
		parent.getContentPane().add(this, BorderLayout.NORTH);
		this.mainWindowMenuHandler = new MainWindowMenuHandler(parent);
		onProjectChanged(null); CoreEvents.registerProjectChangeListener(this); 
		
		ToolBar.INSTANCE = this;
	}

	private JMenuItem findMenu (MenuElement menu, String action) {	
		for (MenuElement element: menu.getSubElements())
			if (element instanceof JMenuItem)
				try {
					JMenuItem item = (JMenuItem) element; if (item == null) continue;
					String command = item.getActionCommand();
					if ((command != null) && (command.equals(action))) return item;
				}
				catch (ClassCastException cce) {
				}
			else
				return findMenu (element, action);
		return null;
	}
	
	private JMenuItem findMenu (MainWindowMenu menu, String action) {
		if (action.startsWith("project")) return findMenu (menu.getProjectMenu(), action);
		if (action.startsWith("edit")) return findMenu ((MenuElement) (menu.editMultipleDefault.getParent()), action);
		if (action.startsWith("goto")) return findMenu ((MenuElement) (menu.gotoHistoryBackMenuItem.getParent()), action);
		if (action.startsWith("tools")) return findMenu (menu.getToolsMenu(), action);
		if (action.startsWith("rev")) return findMenu (menu.getOptionsMenu(), action);
		return null;
	}
	
	private void addJToolBarButton (MainWindowMenu menu, String action, String tips, String iconLocation) {
		URL resource16 = ToolBar.class.getResource("/org/omegat/gui/resources/x16/" + iconLocation);
		URL resource32 = ToolBar.class.getResource("/org/omegat/gui/resources/x32/" + iconLocation);
		
		final JMenuItem item = findMenu (menu, action);
		if (item != null) 
			try { 
				javax.swing.Icon icon32 = new javax.swing.ImageIcon(resource32);
				final AbstractButton btn; 
				if (item instanceof javax.swing.JCheckBoxMenuItem) {
					btn = new JToggleButton(icon32); btn.setSelected(false);
					
					btn.setModel (item.getModel());
				}
				else btn = new JButton (icon32); 
				btn.setActionCommand (action); btn.addActionListener(this);
				this.add (btn);
				
				for (String tip: tips.split(",")) 
					try {
						btn.setToolTipText(OStrings.getString(tip).replaceAll("\\&",""));
						return;
					} catch (java.util.MissingResourceException mre) {
						// does not prevent to create the toolbar
					}
				
				try {
					javax.swing.Icon icon16 = new javax.swing.ImageIcon(resource16);
					item.setIcon (icon16); 
				} catch (Exception e2) {
					// ignore : small icon is not mandatory
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
	}
	
    public void actionPerformed(ActionEvent evt) {
        // Item what perform event.
        AbstractButton menuItem = (AbstractButton) evt.getSource();

        // Get item name from actionCommand.
        String action = menuItem.getActionCommand();

        Log.logInfoRB("LOG_MENU_CLICK", action);

        // Find method by item name.
        String methodName = action + "ActionPerformed";
        Method method = null;
        try {
            method = mainWindowMenuHandler.getClass().getMethod(methodName);
        } catch (NoSuchMethodException ex) {
            throw new IncompatibleClassChangeError(
                    "Error invoke method handler for main menu: there is no method " + methodName);
        }

        // Call ...MenuItemActionPerformed method.
        try {
            method.invoke(mainWindowMenuHandler);
        } catch (IllegalAccessException ex) {
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        } catch (InvocationTargetException ex) {
            LOGGER.log(Level.SEVERE, "Error execute method", ex);
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
    }

	public void onProjectChanged(PROJECT_CHANGE_TYPE eventType) {
		boolean loaded = Core.getProject().isProjectLoaded();
		getComponentAtIndex(0).setEnabled (! loaded); // New
		getComponentAtIndex(1).setEnabled (! loaded); // Open
		getComponentAtIndex(2).setEnabled (loaded); // Reload
		getComponentAtIndex(3).setEnabled (loaded); // Close
		getComponentAtIndex(5).setEnabled (loaded); // Undo
		getComponentAtIndex(6).setEnabled (loaded); // Redo
		getComponentAtIndex(8).setEnabled (loaded); // Find
		getComponentAtIndex(9).setEnabled (loaded); // Replace
		getComponentAtIndex(11).setEnabled (loaded); // Segment prec
		getComponentAtIndex(12).setEnabled (loaded); // Segment suiv
		getComponentAtIndex(13).setEnabled (loaded); // Segment nontrad suiv
		getComponentAtIndex(15).setEnabled (loaded); // Replace by match
		getComponentAtIndex(16).setEnabled (loaded); // Insert match
		getComponentAtIndex(17).setEnabled (loaded); // Replace by TA
		getComponentAtIndex(19).setEnabled (loaded); // Insert markups
		getComponentAtIndex(20).setEnabled (loaded); // Check markups
		
	}
	
	public HighlightPainter getPainter() {
        return null;
    }

	// Old API
    @SuppressWarnings("unchecked")
    public List<Mark> getMarksForEntry(String sourceText, String translationText, boolean isActive)
            throws Exception {
        return Collections.EMPTY_LIST;
    }

	// New API
    @SuppressWarnings("unchecked")
    public List<Mark> getMarksForEntry(org.omegat.core.data.SourceTextEntry entry, String sourceText, String translationText, boolean isActive)
            throws Exception {
        return Collections.EMPTY_LIST;
    }
	
}