/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters4.xml.xliff;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.TMXEntry;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters4.xml.xliff.Xliff1Filter;
import org.omegat.util.Preferences;

public class SdlXliff
extends Xliff1Filter {
    private final SimpleDateFormat TRADOS_DATE_FORMAT = new SimpleDateFormat("M/d/y H:m:s");
    private String currentMid = null;
    private Map<String, StringBuffer> sdlComments = new TreeMap<String, StringBuffer>();
    private StringBuffer commentBuf = null;
    private Map<UUID, String> omegatNotes = new TreeMap<UUID, String>();
    private Map<String, UUID> defaultNoteLocations = new TreeMap<String, UUID>();
    private Map<EntryKey, UUID> altNoteLocations = new TreeMap<EntryKey, UUID>();
    private Map<String, List<XMLEvent>> tagDefs = new TreeMap<String, List<XMLEvent>>();
    private String currentProp = null;
    private Set<String> midSet = new HashSet<String>();
    private boolean has_seg_defs = false;
    private boolean mid_has_modifier = false;
    private boolean mid_has_modif_date = false;

    @Override
    public String getFileFormatName() {
        return "SDL XLIFF (StaX)";
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.sdlxliff")};
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        try {
            StartElement el = this.findEvent(inFile, Pattern.compile(".*/.*:xliff"));
            if (el == null) {
                return false;
            }
            this.namespace = el.getName().getNamespaceURI();
            if (el.getAttributeByName(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "version")) != null) {
                return true;
            }
            return super.isFileSupported(inFile, (Map)config, context);
        }
        catch (Exception npe) {
            return false;
        }
    }

    @Override
    protected void checkCurrentCursorPosition(XMLStreamReader reader, boolean doWrite) {
        if (reader.getEventType() == 1) {
            String name = reader.getLocalName();
            if (name.equals("cmt-defs")) {
                this.isEventMode = true;
            }
            if (name.equals("tag-defs")) {
                this.isEventMode = true;
            }
        }
        super.checkCurrentCursorPosition(reader, doWrite);
    }

    @Override
    protected boolean processStartElement(StartElement startElement, XMLStreamWriter writer) throws XMLStreamException {
        String id;
        if (startElement.getName().getLocalPart().equals("cmt-def")) {
            this.commentBuf = new StringBuffer();
            this.sdlComments.put(startElement.getAttributeByName(new QName("id")).getValue(), this.commentBuf);
            return true;
        }
        if (startElement.getName().getLocalPart().equals("mrk")) {
            if (startElement.getAttributeByName(new QName("mtype")).getValue().equals("seg")) {
                this.currentMid = startElement.getAttributeByName(new QName("mid")).getValue();
                this.midSet.add(this.currentMid);
            } else if (startElement.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-comment")) {
                id = startElement.getAttributeByName(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "cid")).getValue();
                this.addNoteFromSource(this.currentMid, this.sdlComments.get(id).toString());
            }
        }
        if (startElement.getName().getLocalPart().equals("tag")) {
            this.currentBuffer = new LinkedList();
            this.tagDefs.put(startElement.getAttributeByName(new QName("id")).getValue(), this.currentBuffer);
        }
        if (writer != null && startElement.getName().equals(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "seg"))) {
            this.mid_has_modifier = false;
            this.mid_has_modif_date = false;
            this.currentProp = null;
            this.has_seg_defs = true;
            this.fromEventToWriter(eFactory.createStartElement(startElement.getName(), null, startElement.getNamespaces()), writer);
            id = null;
            Iterator<Attribute> I = startElement.getAttributes();
            while (I.hasNext()) {
                Attribute A = I.next();
                if (A.getName().getLocalPart().equals("id")) {
                    id = A.getValue();
                }
                if (A.getName().getLocalPart().equals("conf")) continue;
                writer.writeAttribute(A.getName().getPrefix(), A.getName().getNamespaceURI(), A.getName().getLocalPart(), A.getValue());
            }
            if (id != null && this.isCurrentSegmentTranslated(id)) {
                writer.writeAttribute("conf", "Translated");
            }
            return false;
        }
        if (startElement.getName().getLocalPart().equals("trans-unit")) {
            this.has_seg_defs = false;
        }
        if (startElement.getName().equals(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "value"))) {
            this.currentProp = startElement.getAttributeByName(new QName("key")).getValue();
        }
        return super.processStartElement(startElement, writer);
    }

    @Override
    protected boolean processEndElement(EndElement endElement, XMLStreamWriter writer) throws XMLStreamException {
        if (endElement.getName().getLocalPart().equals("seg")) {
            if (writer != null && this.isCurrentSegmentTranslated(this.currentMid)) {
                if (!this.mid_has_modifier) {
                    writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "value");
                    writer.writeAttribute("key", "last_modified_by");
                    writer.writeCharacters(Preferences.getPreferenceDefault((String)"team_Author", (String)System.getProperty("user.name")));
                    writer.writeEndElement();
                }
                if (!this.mid_has_modif_date) {
                    writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "value");
                    writer.writeAttribute("key", "modified_on");
                    writer.writeCharacters(this.TRADOS_DATE_FORMAT.format(new Date()));
                    writer.writeEndElement();
                }
            }
            this.midSet.remove(this.currentMid);
            this.currentMid = null;
        }
        if (endElement.getName().getLocalPart().equals("trans-unit")) {
            if (writer != null) {
                if (this.midSet.size() > 0 && !this.has_seg_defs) {
                    writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "seg-defs");
                }
                for (String mid0 : this.midSet) {
                    writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "seg");
                    writer.writeAttribute("id", mid0);
                    writer.writeAttribute("conf", "Translated");
                    if (this.isCurrentSegmentTranslated(mid0)) {
                        writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "value");
                        writer.writeAttribute("key", "last_modified_by");
                        writer.writeCharacters(Preferences.getPreferenceDefault((String)"team_Author", (String)System.getProperty("user.name")));
                        writer.writeEndElement();
                        writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "value");
                        writer.writeAttribute("key", "modified_on");
                        writer.writeCharacters(this.TRADOS_DATE_FORMAT.format(new Date()));
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                if (this.midSet.size() > 0 && !this.has_seg_defs) {
                    writer.writeEndElement();
                }
            }
            this.midSet.clear();
        }
        if (endElement.getName().getLocalPart().equals("tag")) {
            this.currentBuffer = null;
        }
        if (endElement.getName().getLocalPart().equals("cmt-def")) {
            this.commentBuf = null;
        }
        if (endElement.getName().getLocalPart().equals("cmt-defs")) {
            this.isEventMode = false;
            if (writer != null) {
                IProject proj = Core.getProject();
                proj.iterateByDefaultTranslations((source, trans) -> {
                    if (!trans.hasNote()) {
                        return;
                    }
                    UUID id = UUID.randomUUID();
                    this.omegatNotes.put(id, trans.note);
                    this.defaultNoteLocations.put(source, id);
                    SdlXliff.createSdlNote(id, trans, writer);
                });
                proj.iterateByMultipleTranslations((key, trans) -> {
                    if (!trans.hasNote()) {
                        return;
                    }
                    UUID id = UUID.randomUUID();
                    this.omegatNotes.put(id, trans.note);
                    this.altNoteLocations.put(key, id);
                    SdlXliff.createSdlNote(id, trans, writer);
                });
            }
            return false;
        }
        return super.processEndElement(endElement, writer);
    }

    @Override
    protected boolean isUntaggedTag(StartElement stEl) {
        return stEl.getName().equals(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk")) && (stEl.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-comment") || stEl.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-added")) || super.isUntaggedTag(stEl);
    }

    @Override
    protected boolean isDeletedTag(StartElement stEl) {
        return stEl.getName().equals(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk")) && stEl.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-deleted") || super.isUntaggedTag(stEl);
    }

    @Override
    protected char findPrefix(StartElement stEl) {
        if (stEl.getName().getLocalPart().equals("g")) {
            try {
                String tagId = stEl.getAttributeByName(new QName("id")).getValue();
                List<XMLEvent> contents = this.tagDefs.get(tagId);
                for (XMLEvent ev : contents) {
                    String name;
                    if (ev.isCharacters()) {
                        String txt = ev.asCharacters().getData();
                        if (txt.contains("italic") && !txt.contains("bold")) {
                            return 'i';
                        }
                        if (!txt.contains("italic") && (txt.contains("bold") || txt.contains("strong"))) {
                            return 'b';
                        }
                        if (txt.contains("size")) {
                            return 's';
                        }
                        if (txt.contains("color")) {
                            return 'c';
                        }
                        if (txt.contains("footnote")) {
                            return 'n';
                        }
                        if (!txt.contains("cf")) continue;
                        return 'f';
                    }
                    if (!ev.isStartElement() || !(name = ev.asStartElement().getName().getLocalPart()).equals("bpt") && !name.equals("ept")) continue;
                    name = ev.asStartElement().getAttributeByName(new QName("name")).getValue();
                    if (name.equals("italic") || name.equals("em")) {
                        return 'i';
                    }
                    if (!name.equals("bold") && !name.equals("strong")) continue;
                    return 'b';
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.findPrefix(stEl);
    }

    private static void createSdlNote(UUID id, TMXEntry trans, XMLStreamWriter writer) {
        try {
            writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "cmt-def");
            writer.writeAttribute("id", id.toString());
            writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "Comments");
            writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "Comment");
            writer.writeCharacters(trans.note);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean processCharacters(Characters event, XMLStreamWriter writer) throws XMLStreamException {
        if (this.commentBuf != null) {
            this.commentBuf.append(event.toString());
            if (writer != null && this.isCurrentSegmentTranslated(this.currentMid)) {
                if ("last_modified_by".equals(this.currentProp)) {
                    writer.writeCharacters(Preferences.getPreferenceDefault((String)"team_Author", (String)System.getProperty("user.name")));
                    this.mid_has_modifier = true;
                    return false;
                }
                if ("modified_on".equals(this.currentProp)) {
                    writer.writeCharacters(this.TRADOS_DATE_FORMAT.format(new Date()));
                    this.mid_has_modif_date = true;
                    return false;
                }
            }
        }
        return super.processCharacters(event, writer);
    }

    @Override
    protected List<XMLEvent> restoreTags(String unitId, String path, String src, String tra) {
        List<XMLEvent> res = super.restoreTags(unitId, path, src, tra);
        EntryKey key = new EntryKey("", src, unitId, null, null, path);
        UUID addNote = null;
        if (this.altNoteLocations.get(key) != null) {
            addNote = this.altNoteLocations.get(key);
        } else if (this.defaultNoteLocations.get(src) != null) {
            addNote = this.defaultNoteLocations.get(src);
        }
        if (addNote != null && this.omegatNotes.get(addNote) != null) {
            LinkedList<Attribute> attr = new LinkedList<Attribute>();
            attr.add(eFactory.createAttribute("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "cid", addNote.toString()));
            attr.add(eFactory.createAttribute(new QName("mtype"), "x-sdl-comment"));
            res.add(0, eFactory.createStartElement(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk"), attr.iterator(), null));
            res.add(eFactory.createEndElement(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk"), null));
        }
        return res;
    }

    @Override
    protected boolean isToIgnore(String src, String tra) {
        if (tra == null) {
            return false;
        }
        while (src.startsWith("<")) {
            src = src.substring(Math.max(1, src.indexOf(">") + 1));
        }
        while (tra.startsWith("<")) {
            tra = tra.substring(Math.max(1, tra.indexOf(">") + 1));
        }
        return src.length() == 0 && tra.length() == 0;
    }

    @Override
    protected String buildProtectedPartDetails(List<XMLEvent> saved) {
        List<XMLEvent> tagDefList;
        String base = super.buildProtectedPartDetails(saved);
        Matcher matcher = Pattern.compile("(\\w) id=\"?([\\d\\w\\-]+)\"?").matcher(base);
        if (matcher.find() && (tagDefList = this.tagDefs.get(matcher.group(2))) != null) {
            StringWriter writer = new StringWriter();
            try {
                XMLEventWriter eventWriter = this.oFactory.createXMLEventWriter(writer);
                for (XMLEvent ev : tagDefList) {
                    eventWriter.add(ev);
                }
            }
            catch (XMLStreamException xe) {
                try {
                    for (XMLEvent ev : saved) {
                        if (ev.isEndElement()) {
                            ((Writer)writer).write("</" + ev.asEndElement().getName().getPrefix() + ":" + ev.asEndElement().getName().getLocalPart() + ">");
                            continue;
                        }
                        ((Writer)writer).write(ev.toString());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return base + ": " + ((Object)writer).toString();
        }
        return base;
    }

    @Override
    protected boolean isStandardTranslationState() {
        return false;
    }
}

