/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2019 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.filters4.xml.xliff;

import java.util.List;

import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;

import org.omegat.filters2.Instance;

/**
 * Overrides XLiff-1 for features which only work with MQ-Xliff (MemoQ)
 *
 * @author Thomas Cordonnier
 */
public class MqXliff extends Xliff1Filter {
    
    // ---------------------------- IFilter API ----------------------------
    
    @Override
    public String getFileFormatName() {
        return "MemoQ XLIFF (StaX)";
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]  { new Instance("*.mqxliff") };
    }
    
    // ---------------------------- Ignore history ----------------------------

    private boolean inHistory = false;
    
    @Override
    protected boolean processStartElement (StartElement startElement, XMLStreamWriter writer) throws XMLStreamException {
        if (startElement.getName().getLocalPart().equals("historical-unit")) inHistory = true;
        if (inHistory) return true; else return super.processStartElement(startElement, writer);
    }
    
    @Override
    protected boolean processEndElement (EndElement endElement, XMLStreamWriter writer) throws XMLStreamException {
        if (endElement.getName().getLocalPart().equals("historical-unit")) { inHistory = false; return true; }
        if (inHistory) return true; else return super.processEndElement(endElement, writer);
    }
    
    @Override
    protected boolean processCharacters (Characters event, XMLStreamWriter writer) throws XMLStreamException { 
        if (inHistory) return true; else return super.processCharacters(event, writer);
    }
    
    // ---------------------------- Find prefix for roleless  ----------------------------
    
    protected String buildTags (List<XMLEvent> srcList, boolean reuse) {
        String res = super.buildTags (srcList, reuse);
        return res;
    }
    
}
