/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.xml.xliff;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.Instance;
import org.omegat.filters2.xml.AbstractXmlFilter;

abstract class AbstractXliffFilter
extends AbstractXmlFilter {
    protected String namespace = null;
    protected String path = "/";
    protected String ignoreScope = null;
    protected List<XMLEvent> currentBuffer = null;
    protected boolean inTarget = false;
    protected List<XMLEvent> source = new LinkedList<XMLEvent>();
    protected List<XMLEvent> target = null;
    protected List<XMLEvent> note = new LinkedList<XMLEvent>();
    protected Map<Character, Integer> tagsCount = new TreeMap<Character, Integer>();
    protected Stack<String> tagStack = new Stack();
    protected Map<String, String> pairedHolders = new TreeMap<String, String>();
    protected static final XMLEventFactory eFactory = XMLEventFactory.newInstance();

    AbstractXliffFilter() {
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.xlf"), new Instance("*.xliff")};
    }

    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        try {
            StartElement el = this.findEvent(inFile, Pattern.compile(".*/.*:xliff"));
            if (el == null) {
                return false;
            }
            if (el.getAttributeByName(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "version")) != null) {
                return false;
            }
            this.namespace = el.getName().getNamespaceURI();
            if (this.namespace.startsWith("urn:oasis:names:tc:xliff:document:" + this.versionPrefix())) {
                return true;
            }
            if (this.namespace.startsWith("urn:oasis:names:tc:xliff:document:")) {
                return false;
            }
            String version = el.getAttributeByName(new QName("version")).getValue();
            this.namespace = "urn:oasis:names:tc:xliff:document:" + version;
            return version.startsWith(this.versionPrefix());
        }
        catch (Exception npe) {
            return false;
        }
    }

    protected abstract String versionPrefix();

    protected void cleanBuffers() {
        this.source.clear();
        this.target = null;
        this.note.clear();
    }

    @Override
    protected boolean processCharacters(Characters event, XMLEventWriter evWriter) {
        if (this.currentBuffer != null) {
            this.currentBuffer.add(event);
        }
        return !this.inTarget;
    }

    protected void updateIgnoreScope(StartElement startElement) {
        if (startElement.getAttributeByName(new QName("translate")) != null) {
            if ("no".equals(startElement.getAttributeByName(new QName("translate")).getValue())) {
                this.ignoreScope = startElement.getName().getLocalPart();
            } else if ("yes".equals(startElement.getAttributeByName(new QName("translate")).getValue()) && this.ignoreScope != null) {
                this.ignoreScope = "!" + startElement.getName().getLocalPart() + " " + this.ignoreScope;
            }
        }
    }

    protected abstract String buildTags(List<XMLEvent> var1, boolean var2);

    protected boolean isToIgnore(String src, String tra) {
        return false;
    }

    protected void registerCurrentTransUnit(String entryId, List<XMLEvent> unitSource, List<XMLEvent> unitTarget, String notePattern) {
        String src = this.buildTags(unitSource, false);
        String tra = null;
        if (unitTarget != null && unitTarget.size() > 0) {
            tra = this.buildTags(unitTarget, true);
        }
        if (this.isToIgnore(src, tra)) {
            return;
        }
        if (this.entryParseCallback != null) {
            StringBuffer noteStr = null;
            if (notePattern != null && this.note != null && this.note.size() > 0) {
                noteStr = new StringBuffer();
                for (XMLEvent ev : this.note) {
                    noteStr.append(ev.toString());
                }
            }
            if (notePattern != null && !".*".equals(notePattern)) {
                ArrayList<String> subNoteBuf = new ArrayList<String>();
                boolean found = false;
                if (noteStr != null) {
                    Matcher noteMatch = Pattern.compile(notePattern).matcher(noteStr.toString());
                    while (noteMatch.find()) {
                        found = true;
                        if (!noteMatch.group(1).equals(entryId.substring(entryId.lastIndexOf("/") + 1))) continue;
                        subNoteBuf.add(noteMatch.group(2));
                    }
                }
                if (found && subNoteBuf.size() == 0) {
                    noteStr = new StringBuffer();
                } else if (subNoteBuf.size() == 1) {
                    noteStr = new StringBuffer((String)subNoteBuf.get(0));
                } else {
                    noteStr = new StringBuffer();
                    for (String st : subNoteBuf) {
                        noteStr.append(" - " + st + "\n");
                    }
                }
            }
            this.entryParseCallback.addEntry(entryId, src.toString(), tra, false, noteStr == null ? null : noteStr.toString(), this.path, (IFilter)this, this.buildProtectedParts(src));
        }
        if (this.entryAlignCallback != null) {
            this.entryAlignCallback.addTranslation(entryId, src.toString(), tra.toString(), false, this.path, (IFilter)this);
        }
    }

    protected abstract String[] getPairIdNames(boolean var1);

    protected String startPair(boolean reuse, boolean isEmpty, StartElement stEl, char prefix, int count, List<XMLEvent> nativeCode) {
        if (reuse) {
            return this.findKey(stEl, isEmpty);
        }
        this.tagsMap.put("" + prefix + count, nativeCode);
        if (!isEmpty) {
            String attrName;
            Attribute pairId = null;
            String[] stringArray = this.getPairIdNames(true);
            int n = stringArray.length;
            for (int i = 0; i < n && (pairId = stEl.getAttributeByName(new QName(attrName = stringArray[i]))) == null; ++i) {
            }
            this.pairedHolders.put("" + prefix + "-" + pairId.getValue(), "" + prefix + count);
        }
        return "<" + prefix + count + (isEmpty ? "/" : "") + ">";
    }

    protected String endPair(boolean reuse, StartElement stEl, char prefix, int count, List<XMLEvent> nativeCode) {
        String attrName;
        this.tagsCount.put(Character.valueOf(prefix), count);
        Attribute pairId = null;
        String[] stringArray = this.getPairIdNames(false);
        int n = stringArray.length;
        for (int i = 0; i < n && (pairId = stEl.getAttributeByName(new QName(attrName = stringArray[i]))) == null; ++i) {
        }
        String key = this.pairedHolders.get("" + prefix + "-" + pairId.getValue());
        if (!reuse) {
            this.tagsMap.put("/" + key, nativeCode);
        }
        return "</" + key + ">";
    }

    protected void startStackElement(boolean reuse, StartElement stEl, char prefix, int count, StringBuffer res) {
        if (reuse) {
            String k = this.findKey(stEl, false);
            Matcher m = OMEGAT_TAG.matcher(k);
            if (m.matches()) {
                this.tagStack.push(m.group(2));
                res.append(k);
            } else {
                this.tagStack.push("z" + count);
                res.append("<z").append(count).append(">");
            }
        } else {
            this.tagsMap.put("" + prefix + count, Collections.singletonList(stEl));
            res.append("<").append(prefix).append(count).append(">");
            this.tagStack.push("" + prefix + count);
        }
    }
}

