/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.xml.xliff;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.TMXEntry;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.xml.xliff.Xliff1Filter;

public class SdlXliff
extends Xliff1Filter {
    private String currentMid = null;
    private Map<String, StringBuffer> sdlComments = new TreeMap<String, StringBuffer>();
    private StringBuffer commentBuf = null;
    private Map<UUID, String> omegatNotes = new TreeMap<UUID, String>();
    private Map<String, UUID> defaultNoteLocations = new TreeMap<String, UUID>();
    private Map<EntryKey, UUID> altNoteLocations = new TreeMap<EntryKey, UUID>();
    private Map<String, List<XMLEvent>> tagDefs = new TreeMap<String, List<XMLEvent>>();

    @Override
    public String getFileFormatName() {
        return "SDL XLIFF - StaX";
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.sdlxliff")};
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        try {
            StartElement el = this.findEvent(inFile, Pattern.compile(".*/.*:xliff"));
            if (el == null) {
                return false;
            }
            this.namespace = el.getName().getNamespaceURI();
            if (el.getAttributeByName(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "version")) != null) {
                return true;
            }
            return super.isFileSupported(inFile, (Map)config, context);
        }
        catch (Exception npe) {
            return false;
        }
    }

    @Override
    protected boolean processStartElement(StartElement startElement, XMLEventWriter evWriter) throws XMLStreamException {
        if (startElement.getName().getLocalPart().equals("cmt-def")) {
            this.commentBuf = new StringBuffer();
            this.sdlComments.put(startElement.getAttributeByName(new QName("id")).getValue(), this.commentBuf);
            return true;
        }
        if (startElement.getName().getLocalPart().equals("mrk")) {
            if (startElement.getAttributeByName(new QName("mtype")).getValue().equals("seg")) {
                this.currentMid = startElement.getAttributeByName(new QName("mid")).getValue();
            } else if (startElement.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-comment")) {
                String id = startElement.getAttributeByName(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "cid")).getValue();
                this.addNoteFromSource(this.currentMid, this.sdlComments.get(id).toString());
            }
        }
        if (startElement.getName().getLocalPart().equals("tag")) {
            this.currentBuffer = new LinkedList();
            this.tagDefs.put(startElement.getAttributeByName(new QName("id")).getValue(), this.currentBuffer);
        }
        if (evWriter != null && startElement.getName().equals(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "seg"))) {
            Attribute A;
            LinkedList<Attribute> l = new LinkedList<Attribute>();
            Iterator<Attribute> I = startElement.getAttributes();
            while (I.hasNext()) {
                A = I.next();
                if (A.getName().getLocalPart().equals("conf")) continue;
                l.add(A);
            }
            Attribute mid = startElement.getAttributeByName(new QName("id"));
            if (mid == null) {
                A = startElement.getAttributeByName(new QName("conf"));
                if (A != null) {
                    l.add(A);
                }
            } else if (this.isCurrentSegmentTranslated(mid.getValue())) {
                Attribute na = eFactory.createAttribute("conf", "Translated");
                l.add(na);
            }
            evWriter.add(eFactory.createStartElement(startElement.getName(), l.iterator(), startElement.getNamespaces()));
            return false;
        }
        return super.processStartElement(startElement, evWriter);
    }

    @Override
    protected boolean processEndElement(EndElement endElement, XMLEventWriter evWriter) throws XMLStreamException {
        if (endElement.getName().getLocalPart().equals("tag")) {
            this.currentBuffer = null;
        }
        if (endElement.getName().getLocalPart().equals("cmt-def")) {
            this.commentBuf = null;
        }
        if (endElement.getName().getLocalPart().equals("cmt-defs") && evWriter != null) {
            IProject proj = Core.getProject();
            proj.iterateByDefaultTranslations((source, trans) -> {
                if (!trans.hasNote()) {
                    return;
                }
                UUID id = UUID.randomUUID();
                this.omegatNotes.put(id, trans.note);
                this.defaultNoteLocations.put(source, id);
                SdlXliff.createSdlNote(id, trans, evWriter);
            });
            proj.iterateByMultipleTranslations((key, trans) -> {
                if (!trans.hasNote()) {
                    return;
                }
                UUID id = UUID.randomUUID();
                this.omegatNotes.put(id, trans.note);
                this.altNoteLocations.put(key, id);
                SdlXliff.createSdlNote(id, trans, evWriter);
            });
        }
        return super.processEndElement(endElement, evWriter);
    }

    @Override
    protected boolean isIngoredTag(StartElement stEl) {
        return stEl.getName().equals(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk")) && stEl.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-comment") || super.isIngoredTag(stEl);
    }

    @Override
    protected char findPrefix(StartElement stEl) {
        if (stEl.getName().getLocalPart().equals("g")) {
            try {
                String tagId = stEl.getAttributeByName(new QName("id")).getValue();
                List<XMLEvent> contents = this.tagDefs.get(tagId);
                for (XMLEvent ev : contents) {
                    String name;
                    if (ev.isCharacters()) {
                        String txt = ev.asCharacters().getData();
                        if (txt.contains("italic") && !txt.contains("bold")) {
                            return 'i';
                        }
                        if (!txt.contains("italic") && (txt.contains("bold") || txt.contains("strong"))) {
                            return 'b';
                        }
                        if (txt.contains("size")) {
                            return 's';
                        }
                        if (txt.contains("color")) {
                            return 'c';
                        }
                        if (txt.contains("footnote")) {
                            return 'n';
                        }
                        if (!txt.contains("cf")) continue;
                        return 'f';
                    }
                    if (!ev.isStartElement() || !(name = ev.asStartElement().getName().getLocalPart()).equals("bpt") && !name.equals("ept")) continue;
                    name = ev.asStartElement().getAttributeByName(new QName("name")).getValue();
                    if (name.equals("italic") || name.equals("em")) {
                        return 'i';
                    }
                    if (!name.equals("bold") && !name.equals("strong")) continue;
                    return 'b';
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.findPrefix(stEl);
    }

    private static void createSdlNote(UUID id, TMXEntry trans, XMLEventWriter evWriter) {
        List<Attribute> attr = Collections.singletonList(eFactory.createAttribute(new QName("id"), id.toString()));
        try {
            evWriter.add(eFactory.createStartElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "cmt-def"), attr.iterator(), null));
            evWriter.add(eFactory.createStartElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "Comments"), null, null));
            evWriter.add(eFactory.createStartElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "Comment"), null, null));
            evWriter.add(eFactory.createCharacters(trans.note));
            evWriter.add(eFactory.createEndElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "Comment"), null));
            evWriter.add(eFactory.createEndElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "Comments"), null));
            evWriter.add(eFactory.createEndElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "cmt-def"), null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean processCharacters(Characters event, XMLEventWriter evWriter) {
        if (this.commentBuf != null) {
            this.commentBuf.append(event.toString());
        }
        return super.processCharacters(event, evWriter);
    }

    @Override
    protected List<XMLEvent> restoreTags(String unitId, String path, String src, String tra) {
        List<XMLEvent> res = super.restoreTags(unitId, path, src, tra);
        EntryKey key = new EntryKey("", src, unitId, null, null, path);
        UUID addNote = null;
        if (this.altNoteLocations.get(key) != null) {
            addNote = this.altNoteLocations.get(key);
        } else if (this.defaultNoteLocations.get(src) != null) {
            addNote = this.defaultNoteLocations.get(src);
        }
        if (addNote != null && this.omegatNotes.get(addNote) != null) {
            LinkedList<Attribute> attr = new LinkedList<Attribute>();
            attr.add(eFactory.createAttribute("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "cid", addNote.toString()));
            attr.add(eFactory.createAttribute(new QName("mtype"), "x-sdl-comment"));
            res.add(0, eFactory.createStartElement(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk"), attr.iterator(), null));
            res.add(eFactory.createEndElement(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk"), null));
        }
        return res;
    }

    @Override
    protected boolean isToIgnore(String src, String tra) {
        if (tra == null) {
            return false;
        }
        while (src.startsWith("<")) {
            src = src.substring(Math.max(1, src.indexOf(">") + 1));
        }
        while (tra.startsWith("<")) {
            tra = tra.substring(Math.max(1, tra.indexOf(">") + 1));
        }
        return src.length() == 0 && tra.length() == 0;
    }
}

