/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.UnsupportedEncodingException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.jna.ISVNMacOsCFLibrary;
import org.tmatesoft.svn.core.internal.util.jna.ISVNMacOsSecurityLibrary;
import org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

class SVNMacOsKeychain {
    private static final int ERR_SEC_ITEM_NOT_FOUND = -25300;

    SVNMacOsKeychain() {
    }

    static boolean isEnabled() {
        return SVNFileUtil.isOSX && JNALibraryLoader.getMacOsSecurityLibrary() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean setPassword(String realm, String userName, String password, boolean nonInteractive) throws SVNException {
        block13: {
            boolean bl;
            block12: {
                ISVNMacOsSecurityLibrary library = JNALibraryLoader.getMacOsSecurityLibrary();
                if (library == null) {
                    return false;
                }
                if (realm == null) {
                    return false;
                }
                if (nonInteractive) {
                    library.SecKeychainSetUserInteractionAllowed(false);
                }
                try {
                    byte[] rawRealm = realm.getBytes("UTF-8");
                    byte[] rawUserName = userName == null ? null : userName.getBytes("UTF-8");
                    int rawUserNameLength = userName == null ? 0 : rawUserName.length;
                    byte[] rawPassword = password.getBytes("UTF-8");
                    PointerByReference itemHolder = new PointerByReference();
                    int status = library.SecKeychainFindGenericPassword(null, rawRealm.length, rawRealm, rawUserNameLength, rawUserName, null, null, itemHolder);
                    if (status == -25300) {
                        status = library.SecKeychainAddGenericPassword(null, rawRealm.length, rawRealm, rawUserNameLength, rawUserName, rawPassword.length, rawPassword, null);
                    } else {
                        Pointer item = itemHolder.getValue();
                        try {
                            status = library.SecKeychainItemModifyAttributesAndData(item, null, rawPassword.length, rawPassword);
                            Object var13_15 = null;
                        }
                        catch (Throwable throwable) {
                            Object var13_16 = null;
                            SVNMacOsKeychain.release(item);
                            throw throwable;
                        }
                        SVNMacOsKeychain.release(item);
                        {
                        }
                    }
                    bl = status == 0;
                    Object var15_18 = null;
                    if (!nonInteractive) break block12;
                    library.SecKeychainSetUserInteractionAllowed(true);
                }
                catch (UnsupportedEncodingException e) {
                    try {
                        SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                        SVNErrorManager.error(error, e, SVNLogType.DEFAULT);
                        Object var15_19 = null;
                        if (!nonInteractive) break block13;
                        library.SecKeychainSetUserInteractionAllowed(true);
                    }
                    catch (Throwable throwable) {
                        Object var15_20 = null;
                        if (nonInteractive) {
                            library.SecKeychainSetUserInteractionAllowed(true);
                        }
                        throw throwable;
                    }
                    {
                    }
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized String getPassword(String realm, String userName, boolean nonInteractive) throws SVNException {
        String string;
        ISVNMacOsSecurityLibrary library;
        block16: {
            String string2;
            block14: {
                library = JNALibraryLoader.getMacOsSecurityLibrary();
                if (library == null) {
                    return null;
                }
                if (realm == null) {
                    return null;
                }
                if (nonInteractive) {
                    library.SecKeychainSetUserInteractionAllowed(false);
                }
                try {
                    try {
                        String password;
                        block15: {
                            byte[] rawRealm = realm.getBytes("UTF-8");
                            byte[] rawUserName = userName == null ? null : userName.getBytes("UTF-8");
                            int rawUserNameLength = userName == null ? 0 : rawUserName.length;
                            IntByReference passwordLengthHolder = new IntByReference();
                            PointerByReference passwordHolder = new PointerByReference();
                            int status = library.SecKeychainFindGenericPassword(null, rawRealm.length, rawRealm, rawUserNameLength, rawUserName, passwordLengthHolder, passwordHolder, null);
                            if (status != 0) {
                                String string3 = null;
                                Object var19_15 = null;
                                if (!nonInteractive) return string3;
                                library.SecKeychainSetUserInteractionAllowed(true);
                                return string3;
                            }
                            Pointer passwordPointer = passwordHolder.getValue();
                            if (passwordPointer == null) {
                                string2 = null;
                                break block14;
                            }
                            int passwordLength = passwordLengthHolder.getValue();
                            byte[] rawPassword = passwordPointer.getByteArray(0L, passwordLength);
                            try {
                                try {
                                    password = new String(rawPassword, "UTF-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                                    SVNErrorManager.error(error, e, SVNLogType.DEFAULT);
                                    password = null;
                                    Object var17_25 = null;
                                    library.SecKeychainItemFreeContent(null, passwordPointer);
                                    break block15;
                                }
                                Object var17_24 = null;
                                library.SecKeychainItemFreeContent(null, passwordPointer);
                            }
                            catch (Throwable throwable) {
                                Object var17_26 = null;
                                library.SecKeychainItemFreeContent(null, passwordPointer);
                                throw throwable;
                            }
                        }
                        string = password;
                        break block16;
                    }
                    catch (UnsupportedEncodingException e) {
                        SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                        SVNErrorManager.error(error, e, SVNLogType.DEFAULT);
                        String string4 = null;
                        Object var19_18 = null;
                        if (!nonInteractive) return string4;
                        library.SecKeychainSetUserInteractionAllowed(true);
                        return string4;
                    }
                }
                catch (Throwable throwable) {
                    Object var19_19 = null;
                    if (!nonInteractive) throw throwable;
                    library.SecKeychainSetUserInteractionAllowed(true);
                    throw throwable;
                }
            }
            Object var19_16 = null;
            if (!nonInteractive) return string2;
            library.SecKeychainSetUserInteractionAllowed(true);
            return string2;
        }
        Object var19_17 = null;
        if (!nonInteractive) return string;
        library.SecKeychainSetUserInteractionAllowed(true);
        return string;
    }

    private static void release(Pointer pointer) {
        ISVNMacOsCFLibrary library;
        if (pointer != null && (library = JNALibraryLoader.getMacOsCFLibrary()) != null) {
            library.CFRelease(pointer);
        }
    }
}

