/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public abstract class AbstractPunctuationCheckRule
extends Rule {
    public AbstractPunctuationCheckRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_misc")));
    }

    @Override
    public String getId() {
        return "PUNCTUATION_GENERIC_CHECK";
    }

    @Override
    public String getDescription() {
        return "Use of unusual combination of punctuation characters";
    }

    protected abstract boolean isPunctsJoinOk(String var1);

    protected abstract boolean isPunctuation(String var1);

    @Override
    public RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokens();
        int startTokenIdx = -1;
        String tkns = "";
        for (int i = 0; i < tokens.length; ++i) {
            String tokenStr = tokens[i].getToken();
            if (this.isPunctuation(tokenStr)) {
                tkns = tkns + tokenStr;
                if (startTokenIdx == -1) {
                    startTokenIdx = i;
                }
                if (i < tokens.length - 1) continue;
            }
            if (tkns.length() >= 2 && !this.isPunctsJoinOk(tkns)) {
                String msg = "bad duplication or combination of punctuation signs";
                RuleMatch ruleMatch = new RuleMatch(this, tokens[startTokenIdx].getStartPos(), tokens[startTokenIdx].getStartPos() + tkns.length(), "bad duplication or combination of punctuation signs", "Punctuation problem");
                ruleMatch.setSuggestedReplacement(tkns.substring(0, 1));
                ruleMatches.add(ruleMatch);
            }
            tkns = "";
            startTokenIdx = -1;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public void reset() {
    }
}

