/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.StringTools;

class PatternRuleMatcher {
    private static final String SUGGESTION_START_TAG = "<suggestion>";
    private static final String SUGGESTION_END_TAG = "</suggestion>";
    private final PatternRule rule;
    private final boolean useList;

    PatternRuleMatcher(PatternRule rule, boolean useList) {
        this.rule = rule;
        this.useList = useList;
    }

    final RuleMatch[] match(AnalyzedSentence text) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        int[] tokenPositions = new int[tokens.length + 1];
        int patternSize = this.rule.patternElements.size();
        int limit = Math.max(0, tokens.length - patternSize + 1);
        Element elem = null;
        for (int i = 0; !(i >= limit || this.rule.sentStart && i > 0); ++i) {
            RuleMatch ruleMatch;
            boolean allElementsMatch = false;
            int firstMatchToken = -1;
            int lastMatchToken = -1;
            int matchingTokens = 0;
            int prevSkipNext = 0;
            int skipShiftTotal = 0;
            if (this.rule.testUnification) {
                this.rule.unifier.reset();
            }
            for (int k = 0; k < patternSize; ++k) {
                Element prevElement = elem;
                elem = (Element)this.rule.patternElements.get(k);
                this.rule.setupRef(firstMatchToken, elem, tokens);
                int nextPos = i + k + skipShiftTotal;
                this.rule.prevMatched = false;
                if (prevSkipNext + nextPos >= tokens.length || prevSkipNext < 0) {
                    prevSkipNext = tokens.length - (nextPos + 1);
                }
                int maxTok = Math.min(nextPos + prevSkipNext, tokens.length - (patternSize - k));
                for (int m = nextPos; m <= maxTok; ++m) {
                    boolean bl = allElementsMatch = !tokens[m].isImmunized() && this.rule.testAllReadings(tokens, elem, prevElement, m, firstMatchToken, prevSkipNext);
                    if (!allElementsMatch) continue;
                    lastMatchToken = m;
                    int skipShift = lastMatchToken - nextPos;
                    tokenPositions[matchingTokens] = skipShift + 1;
                    prevSkipNext = this.translateElementNo(elem.getSkipNext());
                    ++matchingTokens;
                    skipShiftTotal += skipShift;
                    if (firstMatchToken != -1) break;
                    firstMatchToken = lastMatchToken;
                    break;
                }
                if (!allElementsMatch) break;
            }
            if (!allElementsMatch || matchingTokens != patternSize || (ruleMatch = this.createRuleMatch(tokenPositions, tokens, firstMatchToken, lastMatchToken, matchingTokens)) == null) continue;
            ruleMatches.add(ruleMatch);
        }
        return ruleMatches.toArray(new RuleMatch[ruleMatches.size()]);
    }

    private RuleMatch createRuleMatch(int[] tokenPositions, AnalyzedTokenReadings[] tokens, int firstMatchToken, int lastMatchToken, int matchingTokens) throws IOException {
        int toPos;
        AnalyzedTokenReadings firstMatchTokenObj;
        boolean startsWithUppercase;
        String errMessage = this.formatMatches(tokens, tokenPositions, firstMatchToken, this.rule.getMessage(), this.rule.getSuggestionMatches());
        String suggestionsOutMsg = this.formatMatches(tokens, tokenPositions, firstMatchToken, this.rule.getSuggestionsOutMsg(), this.rule.getSuggestionMatchesOutMsg());
        int correctedStPos = 0;
        if (this.rule.startPositionCorrection > 0) {
            for (int l = 0; l <= this.rule.startPositionCorrection; ++l) {
                correctedStPos += tokenPositions[l];
            }
            --correctedStPos;
        }
        int correctedEndPos = 0;
        if (this.rule.endPositionCorrection < 0) {
            for (int l = 0; l > this.rule.endPositionCorrection; --l) {
                correctedEndPos -= tokenPositions[matchingTokens + l - 1];
            }
        }
        boolean bl = startsWithUppercase = StringTools.startsWithUppercase((firstMatchTokenObj = tokens[firstMatchToken + correctedStPos]).getToken()) && !this.matchConvertsCase(this.rule.getSuggestionMatches()) && !this.matchConvertsCase(this.rule.getSuggestionMatchesOutMsg());
        if (firstMatchTokenObj.isSentStart() && tokens.length > firstMatchToken + correctedStPos + 1) {
            firstMatchTokenObj = tokens[firstMatchToken + correctedStPos + 1];
            startsWithUppercase = StringTools.startsWithUppercase(firstMatchTokenObj.getToken());
        }
        int fromPos = tokens[firstMatchToken + correctedStPos].getStartPos();
        if (errMessage.contains("<suggestion>,") && firstMatchToken + correctedStPos >= 1) {
            fromPos = tokens[firstMatchToken + correctedStPos - 1].getStartPos() + tokens[firstMatchToken + correctedStPos - 1].getToken().length();
        }
        if (!(fromPos >= (toPos = tokens[lastMatchToken + correctedEndPos].getStartPos() + tokens[lastMatchToken + correctedEndPos].getToken().length()) || errMessage.contains("<pleasespellme/>") && errMessage.contains("<mistake/>"))) {
            String clearMsg = errMessage.replaceAll("<pleasespellme/>", "").replaceAll("<mistake/>", "");
            return new RuleMatch(this.rule, fromPos, toPos, clearMsg, this.rule.getShortMessage(), startsWithUppercase, suggestionsOutMsg);
        }
        return null;
    }

    private boolean matchConvertsCase(List<Match> suggestionMatches) {
        if (suggestionMatches != null && !suggestionMatches.isEmpty()) {
            int sugStart = this.rule.getMessage().indexOf(SUGGESTION_START_TAG) + SUGGESTION_START_TAG.length();
            for (Match sMatch : suggestionMatches) {
                if (sMatch.isInMessageOnly() || !sMatch.convertsCase() || this.rule.getMessage().charAt(sugStart) != '\\') continue;
                return true;
            }
        }
        return false;
    }

    private int translateElementNo(int i) {
        if (!this.useList || i < 0) {
            return i;
        }
        int j = 0;
        for (int k = 0; k < i; ++k) {
            j += this.rule.getElementNo().get(k).intValue();
        }
        return j;
    }

    private String formatMatches(AnalyzedTokenReadings[] tokenReadings, int[] positions, int firstMatchTok, String errorMsg, List<Match> suggestionMatches) throws IOException {
        String errorMessage = errorMsg;
        int matchCounter = 0;
        int[] numbersToMatches = new int[errorMsg.length()];
        boolean newWay = false;
        int errLen = errorMessage.length();
        int errMarker = errorMessage.indexOf(92);
        boolean numberFollows = false;
        if (errMarker >= 0 && errMarker < errLen - 1) {
            numberFollows = StringTools.isPositiveNumber(errorMessage.charAt(errMarker + 1));
        }
        while (errMarker >= 0 && numberFollows) {
            int backslashPos = errorMessage.indexOf(92);
            if (backslashPos >= 0 && StringTools.isPositiveNumber(errorMessage.charAt(backslashPos + 1))) {
                int numLen = 1;
                while (backslashPos + numLen < errorMessage.length() && StringTools.isPositiveNumber(errorMessage.charAt(backslashPos + numLen))) {
                    ++numLen;
                }
                int j = Integer.parseInt(errorMessage.substring(backslashPos + 1, backslashPos + numLen)) - 1;
                int repTokenPos = 0;
                int nextTokenPos = 0;
                for (int l = 0; l <= j; ++l) {
                    repTokenPos += positions[l];
                }
                if (j <= positions.length) {
                    nextTokenPos = firstMatchTok + repTokenPos + positions[j + 1];
                }
                if (suggestionMatches != null) {
                    if (matchCounter < suggestionMatches.size()) {
                        numbersToMatches[j] = matchCounter;
                        if (suggestionMatches.get(matchCounter) != null) {
                            String[] matches = this.concatMatches(matchCounter, j, firstMatchTok + repTokenPos, tokenReadings, nextTokenPos, suggestionMatches);
                            String leftSide = errorMessage.substring(0, backslashPos);
                            String rightSide = errorMessage.substring(backslashPos + numLen);
                            errorMessage = matches.length == 1 ? leftSide + matches[0] + rightSide : PatternRuleMatcher.formatMultipleSynthesis(matches, leftSide, rightSide);
                            ++matchCounter;
                            newWay = true;
                        }
                    } else {
                        suggestionMatches.add(suggestionMatches.get(numbersToMatches[j]));
                    }
                }
                if (!newWay) {
                    errorMessage = errorMessage.replace("\\" + (j + 1), tokenReadings[firstMatchTok + repTokenPos - 1].getToken());
                }
            }
            errMarker = errorMessage.indexOf(92);
            numberFollows = false;
            errLen = errorMessage.length();
            if (errMarker < 0 || errMarker >= errLen - 1) continue;
            numberFollows = StringTools.isPositiveNumber(errorMessage.charAt(errMarker + 1));
        }
        return errorMessage;
    }

    private static String formatMultipleSynthesis(String[] matches, String leftSide, String rightSide) {
        String suggestionLeft = "";
        String suggestionRight = "";
        String rightSideNew = rightSide;
        int sPos = leftSide.lastIndexOf(SUGGESTION_START_TAG);
        if (sPos > 0) {
            suggestionLeft = leftSide.substring(sPos + SUGGESTION_START_TAG.length());
        }
        String errorMessage = StringTools.isEmpty(suggestionLeft) ? leftSide : leftSide.substring(0, leftSide.lastIndexOf(SUGGESTION_START_TAG)) + SUGGESTION_START_TAG;
        int rPos = rightSide.indexOf(SUGGESTION_END_TAG);
        if (rPos > 0) {
            suggestionRight = rightSide.substring(0, rPos);
        }
        if (!StringTools.isEmpty(suggestionRight)) {
            rightSideNew = rightSide.substring(rightSide.indexOf(SUGGESTION_END_TAG));
        }
        int lastLeftSugEnd = leftSide.indexOf(SUGGESTION_END_TAG);
        int lastLeftSugStart = leftSide.lastIndexOf(SUGGESTION_START_TAG);
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        for (int z = 0; z < matches.length; ++z) {
            sb.append(suggestionLeft);
            sb.append(matches[z]);
            sb.append(suggestionRight);
            if (z >= matches.length - 1 || lastLeftSugEnd >= lastLeftSugStart) continue;
            sb.append(SUGGESTION_END_TAG);
            sb.append(", ");
            sb.append(SUGGESTION_START_TAG);
        }
        sb.append(rightSideNew);
        return sb.toString();
    }

    private String[] concatMatches(int start, int index, int tokenIndex, AnalyzedTokenReadings[] tokens, int nextTokenPos, List<Match> suggestionMatches) throws IOException {
        String[] finalMatch = null;
        if (suggestionMatches.get(start) != null) {
            int len = this.phraseLen(index);
            Language language = this.rule.language;
            if (len == 1) {
                int skippedTokens = nextTokenPos - tokenIndex;
                suggestionMatches.get(start).setToken(tokens, tokenIndex - 1, skippedTokens);
                suggestionMatches.get(start).setSynthesizer(language.getSynthesizer());
                finalMatch = suggestionMatches.get(start).toFinalString(language);
                if (suggestionMatches.get(start).checksSpelling() && finalMatch.length == 1 && "".equals(finalMatch[0])) {
                    finalMatch = new String[]{"<mistake/>"};
                }
            } else {
                ArrayList<String[]> matchList = new ArrayList<String[]>();
                for (int i = 0; i < len; ++i) {
                    int skippedTokens = nextTokenPos - (tokenIndex + i);
                    suggestionMatches.get(start).setToken(tokens, tokenIndex - 1 + i, skippedTokens);
                    suggestionMatches.get(start).setSynthesizer(language.getSynthesizer());
                    matchList.add(suggestionMatches.get(start).toFinalString(language));
                }
                return PatternRuleMatcher.combineLists((String[][])matchList.toArray((T[])new String[matchList.size()][]), new String[matchList.size()], 0, language);
            }
        }
        return finalMatch;
    }

    private int phraseLen(int i) {
        List<Integer> elementNo = this.rule.getElementNo();
        if (!this.useList || i > elementNo.size() - 1) {
            return 1;
        }
        return elementNo.get(i);
    }

    private static String[] combineLists(String[][] input, String[] output, int r, Language lang) {
        ArrayList<String> outputList = new ArrayList<String>();
        if (r == input.length) {
            StringBuilder sb = new StringBuilder();
            for (int k = 0; k < output.length; ++k) {
                sb.append(output[k]);
                if (k >= output.length - 1) continue;
                sb.append(StringTools.addSpace(output[k + 1], lang));
            }
            outputList.add(sb.toString());
        } else {
            for (int c = 0; c < input[r].length; ++c) {
                output[r] = input[r][c];
                String[] sList = PatternRuleMatcher.combineLists(input, output, r + 1, lang);
                outputList.addAll(Arrays.asList(sList));
            }
        }
        return outputList.toArray(new String[outputList.size()]);
    }
}

