/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.awt.Window;
import java.util.ResourceBundle;
import org.madlonkay.supertmxmerge.data.Report;
import org.madlonkay.supertmxmerge.data.ResolutionStrategy;
import org.madlonkay.supertmxmerge.util.LocString;

public class StmProperties {
    private String baseTmxName = LocString.get("STM_BASE_TMX_DEFAULT_NAME");
    private String leftTmxName = LocString.get("STM_LEFT_TMX_DEFAULT_NAME");
    private String rightTmxName = LocString.get("STM_RIGHT_TMX_DEFAULT_NAME");
    private ResourceBundle resource = null;
    private Window parentWindow = null;
    private int listViewThreshold = 5;
    private ResolutionStrategy resolutionStrategy = null;
    private Report report = null;

    public StmProperties setBaseTmxName(String name) {
        this.baseTmxName = name;
        return this;
    }

    public String getBaseTmxName() {
        return this.baseTmxName;
    }

    public StmProperties setTmx1Name(String name) {
        this.leftTmxName = name;
        return this;
    }

    public String geTmx1Name() {
        return this.leftTmxName;
    }

    public StmProperties setTmx2Name(String name) {
        this.rightTmxName = name;
        return this;
    }

    public String getTmx2Name() {
        return this.rightTmxName;
    }

    public StmProperties setLanguageResource(ResourceBundle resource) {
        this.resource = resource;
        return this;
    }

    public ResourceBundle getLanguageResource() {
        return this.resource;
    }

    public StmProperties setParentWindow(Window window) {
        this.parentWindow = window;
        return this;
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    public StmProperties setListViewThreshold(int threshold) {
        if (threshold < 0) {
            throw new IllegalArgumentException("The list view threshold must be at least 0.");
        }
        this.listViewThreshold = threshold;
        return this;
    }

    public int getListViewThreshold() {
        return this.listViewThreshold;
    }

    public ResolutionStrategy getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public StmProperties setResolutionStrategy(ResolutionStrategy resolutionStrategy) {
        this.resolutionStrategy = resolutionStrategy;
        return this;
    }

    public Report getReport() {
        return this.report;
    }

    StmProperties setReport(Report report) {
        this.report = report;
        return this;
    }
}

