/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.madlonkay.supertmxmerge.CombineIOController;
import org.madlonkay.supertmxmerge.DiffIOController;
import org.madlonkay.supertmxmerge.MergeIOController;
import org.madlonkay.supertmxmerge.gui.FileDropHandler;
import org.madlonkay.supertmxmerge.gui.FileStringConverter;
import org.madlonkay.supertmxmerge.gui.IDropCallback;
import org.madlonkay.supertmxmerge.gui.MenuFrame;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class FileSelectWindow
extends JPanel
implements IDropCallback {
    private static final Logger LOGGER = Logger.getLogger(FileSelectWindow.class.getName());
    private static final FileNameExtensionFilter FILTER_TMX = new FileNameExtensionFilter(LocString.get("STM_TMX_FILE_TYPE_LABEL"), "tmx");
    private final Window window;
    private JButton addButton;
    private JPanel addRemoveButtonPanel;
    private JButton baseFileButton;
    private JTextField baseFileField;
    private JPanel combineButtonPanel;
    private JButton combineCancelButton;
    private CombineIOController combineIOController;
    private JList combineList;
    private JButton combineOkButton;
    private JPanel combinePanel;
    private JPanel diffButtonPanel;
    private JButton diffCancelButton;
    private DiffIOController diffIOController;
    private JTabbedPane diffMergeTabbedPane;
    private JButton diffOkButton;
    private JPanel diffPanel;
    private JButton file1Button;
    private JTextField file1Field;
    private JButton file2Button;
    private JTextField file2Field;
    private FileStringConverter fileStringConverter;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel13;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JButton leftFileButton;
    private JTextField leftFileField;
    private JPanel mergeButtonPanel;
    private JButton mergeCancelButton;
    private MergeIOController mergeIOController;
    private JButton mergeOkButton;
    private JPanel mergePanel;
    private JFileChooser multiFileChooser;
    private JButton removeButton;
    private JButton rightFileButton;
    private JTextField rightFileField;
    private JFileChooser singleFileChooser;
    private BindingGroup bindingGroup;

    public static JFrame newAsFrame() {
        MenuFrame frame = new MenuFrame(LocString.get("STM_DIFF_WINDOW_TITLE"));
        if (!GuiUtil.isOSX()) {
            frame.setJMenuBar(null);
        }
        frame.setContentPane(new FileSelectWindow(frame));
        frame.setLocationByPlatform(true);
        frame.setResizable(false);
        frame.pack();
        return frame;
    }

    public FileSelectWindow(Window window) {
        this.window = window;
        this.initComponents();
        FileDropHandler th = new FileDropHandler(this);
        this.file1Field.setTransferHandler(th);
        this.file2Field.setTransferHandler(th);
        this.leftFileField.setTransferHandler(th);
        this.rightFileField.setTransferHandler(th);
        this.baseFileField.setTransferHandler(th);
        this.combineList.setTransferHandler(th);
    }

    @Override
    public void droppedToTarget(Component component) {
        if (component == this.combineList) {
            DefaultListModel model = (DefaultListModel)this.combineList.getModel();
            this.combineIOController.setFiles(model.elements());
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.singleFileChooser = new JFileChooser();
        this.fileStringConverter = new FileStringConverter();
        this.diffIOController = new DiffIOController();
        this.mergeIOController = new MergeIOController();
        this.combineIOController = new CombineIOController();
        this.multiFileChooser = new JFileChooser();
        this.diffMergeTabbedPane = new JTabbedPane();
        this.diffPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.file1Button = new JButton();
        this.file2Button = new JButton();
        this.jPanel4 = new JPanel();
        this.file1Field = new JTextField();
        this.file2Field = new JTextField();
        this.diffButtonPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.diffOkButton = new JButton();
        this.diffCancelButton = new JButton();
        this.mergePanel = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.baseFileButton = new JButton();
        this.leftFileButton = new JButton();
        this.rightFileButton = new JButton();
        this.jPanel8 = new JPanel();
        this.baseFileField = new JTextField();
        this.leftFileField = new JTextField();
        this.rightFileField = new JTextField();
        this.mergeButtonPanel = new JPanel();
        this.jPanel10 = new JPanel();
        this.mergeOkButton = new JButton();
        this.mergeCancelButton = new JButton();
        this.combinePanel = new JPanel();
        this.jPanel9 = new JPanel();
        this.addRemoveButtonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.combineList = new JList();
        this.combineButtonPanel = new JPanel();
        this.jPanel13 = new JPanel();
        this.combineOkButton = new JButton();
        this.combineCancelButton = new JButton();
        this.singleFileChooser.setFileFilter(FILTER_TMX);
        this.multiFileChooser.setFileFilter(FILTER_TMX);
        this.multiFileChooser.setMultiSelectionEnabled(true);
        this.diffPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.diffPanel.setLayout(new BoxLayout(this.diffPanel, 3));
        this.jPanel1.setLayout(new BorderLayout(0, 2));
        this.jPanel3.setLayout(new GridLayout(0, 1));
        this.file1Button.setText(LocString.get("STM_SELECT_BUTTON_FILE1"));
        this.file1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.file1ButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.file1Button);
        this.file2Button.setText(LocString.get("STM_SELECT_BUTTON_FILE2"));
        this.file2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.file2ButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.file2Button);
        this.jPanel1.add((Component)this.jPanel3, "West");
        this.jPanel4.setLayout(new GridLayout(0, 1, 0, 1));
        this.file1Field.setColumns(45);
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.diffIOController, ELProperty.create("${file1}"), this.file1Field, BeanProperty.create("text"), "diffFile1");
        binding.setConverter(this.fileStringConverter);
        this.bindingGroup.addBinding(binding);
        this.jPanel4.add(this.file1Field);
        this.file2Field.setColumns(45);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.diffIOController, ELProperty.create("${file2}"), this.file2Field, BeanProperty.create("text"), "diffFile2");
        binding.setConverter(this.fileStringConverter);
        this.bindingGroup.addBinding(binding);
        this.jPanel4.add(this.file2Field);
        this.jPanel1.add((Component)this.jPanel4, "Center");
        this.jPanel2.add(this.jPanel1);
        this.diffPanel.add(this.jPanel2);
        this.diffButtonPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.diffButtonPanel.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 2));
        this.diffOkButton.setText(LocString.get("STM_OK_BUTTON"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.diffIOController, ELProperty.create("${inputIsValid}"), this.diffOkButton, BeanProperty.create("enabled"), "diffOkButton");
        this.bindingGroup.addBinding(binding);
        this.diffOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.diffOkButtonActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.diffOkButton);
        this.diffCancelButton.setText(LocString.get("STM_CANCEL_BUTTON"));
        this.diffCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.diffCancelButton);
        this.diffButtonPanel.add((Component)this.jPanel5, "East");
        this.diffPanel.add(this.diffButtonPanel);
        this.diffMergeTabbedPane.addTab(LocString.get("STM_FILE_SELECT_DIFF_TAB"), this.diffPanel);
        this.mergePanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.mergePanel.setLayout(new BoxLayout(this.mergePanel, 3));
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel7.setLayout(new GridLayout(0, 1));
        this.baseFileButton.setText(LocString.get("STM_SELECT_BUTTON_BASE_FILE"));
        this.baseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.baseFileButtonActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.baseFileButton);
        this.leftFileButton.setText(LocString.get("STM_SELECT_BUTTON_LEFT_FILE"));
        this.leftFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.leftFileButtonActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.leftFileButton);
        this.rightFileButton.setText(LocString.get("STM_SELECT_BUTTON_RIGHT_FILE"));
        this.rightFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.rightFileButtonActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.rightFileButton);
        this.jPanel6.add((Component)this.jPanel7, "West");
        this.jPanel8.setLayout(new GridLayout(0, 1, 0, 1));
        this.baseFileField.setColumns(20);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.mergeIOController, ELProperty.create("${baseFile}"), this.baseFileField, BeanProperty.create("text"), "mergeBaseFile");
        binding.setConverter(this.fileStringConverter);
        this.bindingGroup.addBinding(binding);
        this.jPanel8.add(this.baseFileField);
        this.leftFileField.setColumns(20);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.mergeIOController, ELProperty.create("${file1}"), this.leftFileField, BeanProperty.create("text"), "mergeFile1");
        binding.setConverter(this.fileStringConverter);
        this.bindingGroup.addBinding(binding);
        this.jPanel8.add(this.leftFileField);
        this.rightFileField.setColumns(20);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.mergeIOController, ELProperty.create("${file2}"), this.rightFileField, BeanProperty.create("text"), "mergeFile2");
        binding.setConverter(this.fileStringConverter);
        this.bindingGroup.addBinding(binding);
        this.jPanel8.add(this.rightFileField);
        this.jPanel6.add((Component)this.jPanel8, "Center");
        this.mergePanel.add(this.jPanel6);
        this.mergeButtonPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.mergeButtonPanel.setLayout(new BorderLayout());
        this.jPanel10.setLayout(new BoxLayout(this.jPanel10, 2));
        this.mergeOkButton.setText(LocString.get("STM_OK_BUTTON"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.mergeIOController, ELProperty.create("${inputIsValid}"), this.mergeOkButton, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.mergeOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.mergeOkButtonActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.mergeOkButton);
        this.mergeCancelButton.setText(LocString.get("STM_CANCEL_BUTTON"));
        this.mergeCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.mergeCancelButton);
        this.mergeButtonPanel.add((Component)this.jPanel10, "East");
        this.mergePanel.add(this.mergeButtonPanel);
        this.diffMergeTabbedPane.addTab(LocString.get("STM_FILE_SELECT_MERGE_TAB"), this.mergePanel);
        this.combinePanel.setLayout(new BoxLayout(this.combinePanel, 3));
        this.jPanel9.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 4));
        this.jPanel9.setLayout(new BoxLayout(this.jPanel9, 2));
        this.addRemoveButtonPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.addRemoveButtonPanel.setLayout(new BoxLayout(this.addRemoveButtonPanel, 3));
        this.addButton.setText(LocString.get("STM_ADD_BUTTON"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.addButtonActionPerformed(evt);
            }
        });
        this.addRemoveButtonPanel.add(this.addButton);
        this.removeButton.setText(LocString.get("STM_REMOVE_BUTTON"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.combineList, ELProperty.create("${not empty selectedElements}"), this.removeButton, BeanProperty.create("enabled"), "listHasSelection");
        this.bindingGroup.addBinding(binding);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.removeButtonActionPerformed(evt);
            }
        });
        this.addRemoveButtonPanel.add(this.removeButton);
        this.jPanel9.add(this.addRemoveButtonPanel);
        this.combineList.setModel(new DefaultListModel());
        this.combineList.setVisibleRowCount(4);
        this.jScrollPane1.setViewportView(this.combineList);
        this.jPanel9.add(this.jScrollPane1);
        this.combinePanel.add(this.jPanel9);
        this.combineButtonPanel.setLayout(new BorderLayout());
        this.jPanel13.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanel13.setLayout(new BoxLayout(this.jPanel13, 2));
        this.combineOkButton.setText(LocString.get("STM_OK_BUTTON"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.combineIOController, ELProperty.create("${inputIsValid}"), this.combineOkButton, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.combineOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.combineOkButtonActionPerformed(evt);
            }
        });
        this.jPanel13.add(this.combineOkButton);
        this.combineCancelButton.setText(LocString.get("STM_CANCEL_BUTTON"));
        this.combineCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectWindow.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel13.add(this.combineCancelButton);
        this.combineButtonPanel.add((Component)this.jPanel13, "East");
        this.combinePanel.add(this.combineButtonPanel);
        this.diffMergeTabbedPane.addTab(LocString.get("STM_COMBINE_BUTTON"), this.combinePanel);
        this.add(this.diffMergeTabbedPane);
        this.bindingGroup.bind();
    }

    private void file1ButtonActionPerformed(ActionEvent evt) {
        if (this.singleFileChooser.showOpenDialog(this) == 0) {
            this.diffIOController.setFile1(this.singleFileChooser.getSelectedFile());
        }
    }

    private void file2ButtonActionPerformed(ActionEvent evt) {
        if (this.singleFileChooser.showOpenDialog(this) == 0) {
            this.diffIOController.setFile2(this.singleFileChooser.getSelectedFile());
        }
    }

    private void baseFileButtonActionPerformed(ActionEvent evt) {
        if (this.singleFileChooser.showOpenDialog(this) == 0) {
            this.mergeIOController.setBaseFile(this.singleFileChooser.getSelectedFile());
        }
    }

    private void leftFileButtonActionPerformed(ActionEvent evt) {
        if (this.singleFileChooser.showOpenDialog(this) == 0) {
            this.mergeIOController.setFile1(this.singleFileChooser.getSelectedFile());
        }
    }

    private void rightFileButtonActionPerformed(ActionEvent evt) {
        if (this.singleFileChooser.showOpenDialog(this) == 0) {
            this.mergeIOController.setFile2(this.singleFileChooser.getSelectedFile());
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.window.dispose();
    }

    private void diffOkButtonActionPerformed(ActionEvent evt) {
        this.window.dispose();
        GuiUtil.safelyRunBlockingRoutine(new Runnable(){

            @Override
            public void run() {
                try {
                    FileSelectWindow.this.diffIOController.go();
                }
                catch (Exception ex) {
                    GuiUtil.showError(ex.getLocalizedMessage());
                }
            }
        });
    }

    private void mergeOkButtonActionPerformed(ActionEvent evt) {
        this.window.dispose();
        GuiUtil.safelyRunBlockingRoutine(new Runnable(){

            @Override
            public void run() {
                try {
                    FileSelectWindow.this.mergeIOController.go();
                }
                catch (Exception ex) {
                    GuiUtil.showError(ex.getLocalizedMessage());
                }
            }
        });
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.combineList.getModel();
        if (this.multiFileChooser.showOpenDialog(this) == 0) {
            for (File file : this.multiFileChooser.getSelectedFiles()) {
                if (model.contains(file)) continue;
                model.addElement(file);
            }
        }
        this.combineIOController.setFiles(model.elements());
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.combineList.getModel();
        Object[] toRemove = this.combineList.getSelectedValues();
        if (toRemove.length == 0) {
            return;
        }
        for (Object o : toRemove) {
            model.removeElement(o);
        }
        this.combineIOController.setFiles(model.elements());
    }

    private void combineOkButtonActionPerformed(ActionEvent evt) {
        this.window.dispose();
        GuiUtil.safelyRunBlockingRoutine(new Runnable(){

            @Override
            public void run() {
                try {
                    FileSelectWindow.this.combineIOController.go();
                }
                catch (Exception ex) {
                    GuiUtil.showError(ex.getLocalizedMessage());
                }
            }
        });
    }
}

