/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.segment.srx.io;

import java.io.Reader;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sourceforge.segment.srx.LanguageRule;
import net.sourceforge.segment.srx.Rule;
import net.sourceforge.segment.srx.SrxDocument;
import net.sourceforge.segment.srx.SrxParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Srx2StaxParser
implements SrxParser {
    private static final Log log = LogFactory.getLog(Srx2StaxParser.class);

    public SrxDocument parse(Reader reader) {
        SrxDocument document = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(reader);
            document = new SrxDocument();
            document.setCascade(true);
            HashMap<String, LanguageRule> languageRuleMap = new HashMap<String, LanguageRule>();
            LanguageRule languageRule = null;
            boolean breakRule = false;
            String beforeBreak = "";
            String afterBreak = "";
            while (parser.hasNext()) {
                String name;
                int event = parser.next();
                if (event == 1) {
                    name = parser.getLocalName();
                    if ("languagerule".equals(name)) {
                        String ruleName = parser.getAttributeValue(0);
                        languageRule = new LanguageRule(ruleName);
                        languageRuleMap.put(languageRule.getName(), languageRule);
                        continue;
                    }
                    if ("languagemap".equals(name)) {
                        String languagePattern = parser.getAttributeValue(0);
                        String languageRuleName = parser.getAttributeValue(1);
                        document.addLanguageMap(languagePattern, (LanguageRule)languageRuleMap.get(languageRuleName));
                        continue;
                    }
                    if ("rule".equals(name)) {
                        breakRule = !"no".equals(parser.getAttributeValue(0));
                        continue;
                    }
                    if ("beforebreak".equals(name)) {
                        beforeBreak = parser.getElementText();
                        continue;
                    }
                    if (!"afterbreak".equals(name)) continue;
                    afterBreak = parser.getElementText();
                    continue;
                }
                if (event != 2 || !"rule".equals(name = parser.getLocalName())) continue;
                Rule rule = new Rule(breakRule, beforeBreak, afterBreak);
                languageRule.addRule(rule);
                breakRule = false;
                beforeBreak = "";
                afterBreak = "";
            }
            parser.close();
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error parsing SRX", (Throwable)e);
        }
        return document;
    }
}

