/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.GermanRule;

public class VerbAgreementRule
extends GermanRule {
    private AnalyzedTokenReadings finiteVerb;
    private static final Set<String> BIN_IGNORE = new HashSet<String>(Arrays.asList("Abdul", "Abdulla", "Abdullah", "Isa", "Muhammed", "Osama", "Said", "Turki", "/"));
    private static final Set<String> QUOTATION_MARKS = new HashSet<String>(Arrays.asList("\"", "\u201e"));

    public VerbAgreementRule(ResourceBundle messages) {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_grammar")));
        }
    }

    public String getId() {
        return "DE_VERBAGREEMENT";
    }

    public String getDescription() {
        return "Kongruenz von Subjekt und Pr\u00e4dikat (nur 1. u. 2. Pers. od. m. Personalpronomen), z.B. 'Er bist (ist)'";
    }

    public RuleMatch[] match(AnalyzedSentence text) {
        int plus1;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        if (tokens.length < 4) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int posIch = -1;
        int posDu = -1;
        int posEr = -1;
        int posWir = -1;
        int posVer1Sin = -1;
        int posVer2Sin = -1;
        int posVer1Plu = -1;
        int posPossibleVer1Sin = -1;
        int posPossibleVer2Sin = -1;
        int posPossibleVer3Sin = -1;
        int posPossibleVer1Plu = -1;
        for (int i = 1; i < tokens.length; ++i) {
            String strToken = tokens[i].getToken().toLowerCase();
            if ((strToken = strToken.replace("\u201a", "")).equals("ich")) {
                posIch = i;
            } else if (strToken.equals("du")) {
                posDu = i;
            } else if (strToken.equals("er")) {
                posEr = i;
            } else if (strToken.equals("wir")) {
                posWir = i;
            }
            if (!tokens[i].hasPartialPosTag("VER") || !Character.isLowerCase(tokens[i].getToken().charAt(0)) && i != 1) continue;
            if (!(!this.hasUnambiguouslyPersonAndNumber(tokens[i], "1", "SIN") || strToken.equals("bin") && (BIN_IGNORE.contains(tokens[i - 1].getToken()) || tokens.length != i + 1 && tokens[i + 1].getToken().startsWith("Laden")))) {
                posVer1Sin = i;
            } else if (this.hasUnambiguouslyPersonAndNumber(tokens[i], "2", "SIN")) {
                posVer2Sin = i;
            } else if (this.hasUnambiguouslyPersonAndNumber(tokens[i], "1", "PLU")) {
                posVer1Plu = i;
            }
            if (tokens[i].hasPartialPosTag(":1:SIN")) {
                posPossibleVer1Sin = i;
            }
            if (tokens[i].hasPartialPosTag(":2:SIN")) {
                posPossibleVer2Sin = i;
            }
            if (tokens[i].hasPartialPosTag(":3:SIN")) {
                posPossibleVer3Sin = i;
            }
            if (!tokens[i].hasPartialPosTag(":1:PLU")) continue;
            posPossibleVer1Plu = i;
        }
        if (posVer1Sin != -1 && posIch == -1 && !this.isQuotationMark(tokens[posVer1Sin - 1])) {
            ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer1Sin]));
        } else if (!(posIch <= 0 || this.isNear(posPossibleVer1Sin, posIch) || !tokens[posIch].getToken().equals("ich") && tokens[posIch].getStartPos() != 0 || this.isQuotationMark(tokens[posIch - 1]))) {
            int n = plus1 = posIch + 1 == tokens.length ? 0 : 1;
            if (!this.verbDoesMatchPersonAndNumber(tokens[posIch - 1], tokens[posIch + plus1], "1", "SIN")) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posIch], this.finiteVerb));
            }
        }
        if (posVer2Sin != -1 && posDu == -1 && !this.isQuotationMark(tokens[posVer2Sin - 1])) {
            ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer2Sin]));
        } else if (posDu > 0 && !this.isNear(posPossibleVer2Sin, posDu) && !this.isQuotationMark(tokens[posDu - 1])) {
            int n = plus1 = posDu + 1 == tokens.length ? 0 : 1;
            if (!this.verbDoesMatchPersonAndNumber(tokens[posDu - 1], tokens[posDu + plus1], "2", "SIN")) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posDu], this.finiteVerb));
            }
        }
        if (posEr > 0 && !this.isNear(posPossibleVer3Sin, posEr) && !this.isQuotationMark(tokens[posEr - 1])) {
            int n = plus1 = posEr + 1 == tokens.length ? 0 : 1;
            if (!this.verbDoesMatchPersonAndNumber(tokens[posEr - 1], tokens[posEr + plus1], "3", "SIN")) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posEr], this.finiteVerb));
            }
        }
        if (posVer1Plu != -1 && posWir == -1 && !this.isQuotationMark(tokens[posVer1Plu - 1])) {
            ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer1Plu]));
        } else if (posWir > 0 && !this.isNear(posPossibleVer1Plu, posWir) && !this.isQuotationMark(tokens[posWir - 1])) {
            int n = plus1 = posWir + 1 == tokens.length ? 0 : 1;
            if (!this.verbDoesMatchPersonAndNumber(tokens[posWir - 1], tokens[posWir + plus1], "1", "PLU")) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posWir], this.finiteVerb));
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isNear(int a, int b) {
        return Math.abs(a - b) < 5 && a != -1;
    }

    private boolean isQuotationMark(AnalyzedTokenReadings token) {
        return QUOTATION_MARKS.contains(token.getToken());
    }

    private boolean hasUnambiguouslyPersonAndNumber(AnalyzedTokenReadings token, String person, String number) {
        if (token.getToken().length() == 0 || Character.isUpperCase(token.getToken().charAt(0)) && token.getStartPos() != 0 || !token.hasPartialPosTag("VER")) {
            return false;
        }
        for (int i = 0; i < token.getReadingsLength(); ++i) {
            String postag = ((AnalyzedToken)token.getReadings().get(i)).getPOSTag();
            if (postag.contains("_END") || postag.contains(":" + person + ":" + number)) continue;
            return false;
        }
        return true;
    }

    private boolean isFiniteVerb(AnalyzedTokenReadings token) {
        if (token.getToken().length() == 0 || Character.isUpperCase(token.getToken().charAt(0)) && token.getStartPos() != 0 || !token.hasPartialPosTag("VER") || token.hasPartialPosTag("PA2") || token.hasPartialPosTag("PRO:") || token.hasPartialPosTag("ZAL")) {
            return false;
        }
        return token.hasPartialPosTag(":1:") || token.hasPartialPosTag(":2:") || token.hasPartialPosTag(":3:");
    }

    private boolean verbDoesMatchPersonAndNumber(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, String person, String number) {
        if (token1.getToken().equals(",") || token1.getToken().equals("und") || token2.getToken().equals(",") || token2.getToken().equals("und")) {
            return true;
        }
        boolean foundFiniteVerb = false;
        if (this.isFiniteVerb(token1)) {
            foundFiniteVerb = true;
            this.finiteVerb = token1;
            if (token1.hasPartialPosTag(":" + person + ":" + number)) {
                return true;
            }
        }
        if (this.isFiniteVerb(token2)) {
            foundFiniteVerb = true;
            this.finiteVerb = token2;
            if (token2.hasPartialPosTag(":" + person + ":" + number)) {
                return true;
            }
        }
        return !foundFiniteVerb;
    }

    private RuleMatch ruleMatchWrongVerb(AnalyzedTokenReadings token) {
        String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Subjekt und Pr\u00e4dikat (" + token.getToken() + ") bez\u00fcglich Person oder Numerus (Einzahl, Mehrzahl - Beispiel: " + "'Max bist' statt 'Max ist').";
        return new RuleMatch((Rule)this, token.getStartPos(), token.getStartPos() + token.getToken().length(), msg);
    }

    private RuleMatch ruleMatchWrongVerbSubject(AnalyzedTokenReadings subject, AnalyzedTokenReadings verb) {
        String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Subjekt (" + subject.getToken() + ") und Pr\u00e4dikat (" + verb.getToken() + ") bez\u00fcglich Person oder Numerus (Einzahl, Mehrzahl - Beispiel: " + "'ich sind' statt 'ich bin').";
        if (subject.getStartPos() < verb.getStartPos()) {
            return new RuleMatch((Rule)this, subject.getStartPos(), verb.getStartPos() + verb.getToken().length(), msg);
        }
        return new RuleMatch((Rule)this, verb.getStartPos(), subject.getStartPos() + subject.getToken().length(), msg);
    }

    public void reset() {
        this.finiteVerb = null;
    }
}

