/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminBasicClient
implements ISVNEventHandler {
    private ISVNRepositoryPool myRepositoryPool;
    private ISVNOptions myOptions;
    private ISVNEventHandler myEventDispatcher;
    private ISVNDebugLog myDebugLog;

    protected SVNRepository createRepository(SVNURL url, String uuid, boolean mayReuse) throws SVNException {
        String reposUUID;
        SVNRepository repository = null;
        repository = this.myRepositoryPool == null ? SVNRepositoryFactory.create(url, null) : this.myRepositoryPool.createRepository(url, mayReuse);
        if (uuid != null && !uuid.equals(reposUUID = repository.getRepositoryUUID(true))) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_UUID_MISMATCH, "Repository UUID ''{0}'' doesn''t match expected UUID ''{1}''", reposUUID, uuid);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        repository.setDebugLog(this.getDebugLog());
        repository.setCanceller(this.getEventDispatcher());
        return repository;
    }

    protected void dispatchEvent(SVNEvent event, double progress) throws SVNException {
        if (this.myEventDispatcher != null) {
            try {
                this.myEventDispatcher.handleEvent(event, progress);
            }
            catch (SVNException e) {
                throw e;
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logSevere(SVNLogType.WC, th);
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Error while dispatching event: {0}", new Object[]{th.getMessage()}, 0, th);
                SVNErrorManager.error(err, th, SVNLogType.DEFAULT);
            }
        }
    }

    public void setDebugLog(ISVNDebugLog log) {
        this.myDebugLog = log;
    }

    public ISVNOptions getOptions() {
        return this.myOptions;
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.myEventDispatcher != null) {
            this.myEventDispatcher.checkCancelled();
        }
    }

    public void setEventHandler(ISVNEventHandler dispatcher) {
        this.myEventDispatcher = dispatcher;
    }

    protected ISVNEventHandler getEventDispatcher() {
        return this.myEventDispatcher;
    }

    protected SVNAdminBasicClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        this(new DefaultSVNRepositoryPool(authManager == null ? SVNWCUtil.createDefaultAuthenticationManager() : authManager, (ISVNTunnelProvider)options, 0L, false), options);
    }

    protected SVNAdminBasicClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        this.myRepositoryPool = repositoryPool;
        this.setOptions(options);
    }

    protected SVNAdminBasicClient(SvnOperationFactory of) {
        this.myRepositoryPool = of.getRepositoryPool();
        this.setOptions(of.getOptions());
    }

    public void setOptions(ISVNOptions options) {
        this.myOptions = options;
        if (this.myOptions == null) {
            this.myOptions = SVNWCUtil.createDefaultOptions(true);
        }
    }

    public ISVNDebugLog getDebugLog() {
        if (this.myDebugLog == null) {
            return SVNDebugLog.getDefaultLog();
        }
        return this.myDebugLog;
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        this.dispatchEvent(event, progress);
    }
}

