/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.segment.srx.io;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import net.sourceforge.segment.srx.SrxTransformer;
import net.sourceforge.segment.srx.io.Srx1Transformer;
import net.sourceforge.segment.srx.io.Srx2Transformer;
import net.sourceforge.segment.srx.io.SrxVersion;
import net.sourceforge.segment.util.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrxAnyTransformer
implements SrxTransformer {
    @Override
    public void transform(Reader reader, Writer writer, Map<String, Object> parameterMap) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        SrxTransformer transformer = this.getTransformer(bufferedReader);
        transformer.transform(bufferedReader, writer, parameterMap);
    }

    @Override
    public Reader transform(Reader reader, Map<String, Object> parameterMap) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        SrxTransformer transformer = this.getTransformer(bufferedReader);
        return transformer.transform(bufferedReader, parameterMap);
    }

    private SrxTransformer getTransformer(BufferedReader reader) {
        SrxTransformer transformer;
        SrxVersion version = SrxVersion.parse(reader);
        if (version == SrxVersion.VERSION_1_0) {
            transformer = new Srx1Transformer();
        } else if (version == SrxVersion.VERSION_2_0) {
            transformer = new Srx2Transformer();
        } else {
            throw new XmlException("Unsupported SRX version: \"" + (Object)((Object)version) + "\".");
        }
        return transformer;
    }
}

