/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.toolbars;

import com.vlsolutions.swing.toolbars.ToolBarGripper;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class ToolBarGripperUI
extends ComponentUI {
    protected static Image gripImage = new ImageIcon(ToolBarGripperUI.class.getResource("gripper.png")).getImage();
    protected static Image gripExpandHImage = new ImageIcon(ToolBarGripperUI.class.getResource("grip_expand_h.png")).getImage();
    protected static Image gripExpandVImage = new ImageIcon(ToolBarGripperUI.class.getResource("grip_expand_v.png")).getImage();

    public static ComponentUI createUI(JComponent c) {
        return new ToolBarGripperUI();
    }

    @Override
    public void installUI(JComponent comp) {
        super.installUI(comp);
        comp.setPreferredSize(new Dimension(4, 4));
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        ToolBarGripper gripper = (ToolBarGripper)comp;
        Insets insets = gripper.getInsets();
        if (gripper.getOrientation() == 0) {
            int dots = gripper.getHeight() / 4 - 1;
            int dotsSize = dots * 4;
            int top = insets.top + gripper.getHeight() / 2 - dotsSize / 2;
            int centerX = insets.left + (gripper.getWidth() - insets.left - insets.right) / 2;
            int i = 0;
            while (i < dots) {
                g.drawImage(gripImage, centerX - 1, top + i * 4 + 1, null);
                ++i;
            }
            if (gripper.isCollapsed()) {
                int centerY = gripper.getHeight() / 2;
                g.drawImage(gripExpandHImage, 0, centerY - 4, null);
            }
        } else {
            int dots = gripper.getWidth() / 4 - 1;
            int i = 0;
            while (i < dots) {
                g.drawImage(gripImage, insets.left + i * 4 + 2, insets.top, null);
                ++i;
            }
            if (gripper.isCollapsed()) {
                int centerX = gripper.getWidth() / 2;
                g.drawImage(gripExpandVImage, centerX - 4, 0, null);
            }
        }
        super.paint(g, comp);
    }
}

