/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.madlonkay.supertmxmerge.MergeController;
import org.madlonkay.supertmxmerge.data.JAXB.JAXBTmx;
import org.madlonkay.supertmxmerge.data.WriteFailedException;
import org.madlonkay.supertmxmerge.gui.ProgressWindow;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class CombineIOController {
    private static final Logger LOGGER = Logger.getLogger(CombineIOController.class.getName());
    private final PropertyChangeSupport propertySupport;
    public static final String PROP_INPUTISVALID = "inputIsValid";
    public static final String PROP_OUTPUTFILE = "outputFile";
    private List<File> files = new ArrayList<File>();
    private File outputFile;

    public CombineIOController() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void addFile(File file) {
        if (!this.files.contains(file)) {
            this.files.add(file);
            this.propertySupport.firePropertyChange(PROP_INPUTISVALID, null, null);
        }
    }

    public void setFiles(Enumeration<File> files) {
        this.files = Collections.list(files);
        this.propertySupport.firePropertyChange(PROP_INPUTISVALID, null, null);
    }

    public void setFiles(File[] files) {
        this.files = Arrays.asList(files);
        this.propertySupport.firePropertyChange(PROP_INPUTISVALID, null, null);
    }

    public boolean getInputIsValid() {
        return this.files.size() >= 2;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        File oldOutputFile = this.outputFile;
        this.outputFile = outputFile;
        this.propertySupport.firePropertyChange(PROP_OUTPUTFILE, oldOutputFile, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        ProgressWindow progress = null;
        if (!GraphicsEnvironment.isHeadless()) {
            progress = new ProgressWindow();
            progress.setMustPopup(true);
            progress.setMaximum(this.files.size());
        }
        try {
            JAXBTmx combined;
            try {
                File firstFile = this.files.get(0);
                this.updateProgress(progress, 0, LocString.getFormat("STM_FILE_PROGRESS", firstFile.getName(), 1, this.files.size()));
                combined = new JAXBTmx(firstFile);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            JAXBTmx empty = JAXBTmx.newEmptyJAXBTmx(combined);
            MergeController merger = new MergeController();
            merger.setIsTwoWayMerge(true);
            for (int i = 1; i < this.files.size(); ++i) {
                try {
                    File thisFile = this.files.get(i);
                    this.updateProgress(progress, i, LocString.getFormat("STM_FILE_PROGRESS", thisFile.getName(), i + 1, this.files.size()));
                    JAXBTmx next = new JAXBTmx(thisFile);
                    combined = (JAXBTmx)merger.merge(empty, combined, next);
                    if (combined != null) continue;
                    return;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            this.updateProgress(progress, this.files.size(), LocString.get("STM_COMBINE_COMPLETE"));
            while (this.getOutputFile() == null) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showSaveDialog(progress) == 0) {
                    this.setOutputFile(chooser.getSelectedFile());
                    continue;
                }
                int response = JOptionPane.showConfirmDialog(progress, LocString.get("STM_CONFIRM_CANCEL_SAVE_MESSAGE"), LocString.get("STM_COMBINE_WINDOW_TITLE"), 0, 2);
                if (response != 0) continue;
                return;
            }
            try {
                combined.writeTo(this.getOutputFile());
            }
            catch (WriteFailedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (progress != null) {
                GuiUtil.closeWindow(progress);
            }
        }
    }

    private void updateProgress(ProgressWindow window, int value, String message) {
        if (window != null) {
            window.setValue(value);
            if (message != null) {
                window.setMessage(message);
            }
        }
    }
}

