/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2010 Antonio Vilei
               2012 Thomas Cordonnier
               2014 Piotr Kulik
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.search;

import java.util.List;

/**
 * Storage for a search result entry inside the project
 * 
 * @author Antonio Vilei
 * @author Thomas Cordonnier
 */
public abstract class FullSearchResultEntry extends SearchResultEntry {

    /**
     * Fills matches parts
     * 
     * @param srcMatch
     *            What has been found in source
     * @param target
     *            What has been found in target
     * @param note
     *            What has been found in note
     */
    protected FullSearchResultEntry(List<SearchMatch> srcMatch, List<SearchMatch> targetMatch, List<SearchMatch> noteMatch) {
        m_srcMatch = srcMatch;
        m_targetMatch = targetMatch;
        m_noteMatch = noteMatch;
    }

    public List<SearchMatch> getSrcMatch() {
        return m_srcMatch;
    }

    public List<SearchMatch> getTargetMatch() {
        return m_targetMatch;
    }

    public List<SearchMatch> getNoteMatch() {
        return m_noteMatch;
    }
    
    private List<SearchMatch> m_srcMatch, m_targetMatch, m_noteMatch;
}
