/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2016-2021 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.gui.dialogs;

import java.io.*;
import java.awt.*;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.JFileChooser;

import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;

/**
 * 
 * @author Thomas Cordonnier
 */
@SuppressWarnings("serial")
public class ExternToolsDialog extends JDialog {
    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;

    /** Creates new form WorkflowOptionsDialog */
    public ExternToolsDialog(Frame parent) {
        super(parent, true);

        StaticUIUtils.setEscapeClosable(this);

        initComponents();

        getRootPane().setDefaultButton(okButton);

        invalidate();
        pack();
        DockingUI.displayCentered(this);
    }

    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus() {
        return returnStatus;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        setTitle(OStrings.getString("EXTERN_TOOLS_DIALOG")); // NOI18N
        setMinimumSize(new java.awt.Dimension(400, 150));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                doClose(RET_CANCEL);
            }
        });


        java.awt.GridBagConstraints gridBagConstraints;

        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        JPanel line1 = new JPanel(), line2 = new JPanel(), line3 = new JPanel(), line4 = new JPanel(), line5 = new JPanel();
        getContentPane().setLayout(new javax.swing.BoxLayout(getContentPane(), javax.swing.BoxLayout.Y_AXIS));
        getContentPane().add(line1); getContentPane().add(new JPanel()); 
        getContentPane().add(line2); getContentPane().add(line3); getContentPane().add(line4); 
        
        line1.setLayout (new java.awt.BorderLayout());
        line1.add(new JLabel(OStrings.getString("EXT_TOOLS_PERL_PATH")), java.awt.BorderLayout.LINE_START);
        line1.add(perlPath = new JTextField(), java.awt.BorderLayout.CENTER);
        perlPath.setText (Preferences.getPreference(Preferences.PERL_PATH));
        JButton btnBrowse = new JButton ("Browse"); line1.add(btnBrowse, java.awt.BorderLayout.LINE_END);
        btnBrowse.addActionListener(evt -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Search Perl Interpreter");
            int result = fileChooser.showOpenDialog(ExternToolsDialog.this);
            if (result == JFileChooser.APPROVE_OPTION) {
                File file = fileChooser.getSelectedFile();
                perlPath.setText(file.getAbsolutePath());
            }
        });       

		
        line2.setLayout (new java.awt.BorderLayout());
        line2.add(new JLabel(OStrings.getString("EXT_TOOLS_TRADOS_PATH")), java.awt.BorderLayout.LINE_START);
        line2.add(tradosPath = new JTextField(), java.awt.BorderLayout.CENTER);
        tradosPath.setText (Preferences.getPreference(Preferences.TRADOS_PATH));
        btnBrowse = new JButton ("Browse"); line2.add(btnBrowse, java.awt.BorderLayout.LINE_END);
        btnBrowse.addActionListener(evt -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            fileChooser.setDialogTitle("Search Trados Directory");
            int result = fileChooser.showOpenDialog(ExternToolsDialog.this);
            if (result == JFileChooser.APPROVE_OPTION) {
                File file = fileChooser.getSelectedFile();
                tradosPath.setText(file.getAbsolutePath());
            }
        });
        
        line3.setLayout (new java.awt.BorderLayout());
        line3.add(new JLabel(OStrings.getString("EXT_TOOLS_TRADOS_COMMAND")), java.awt.BorderLayout.LINE_START);
        line3.add(commandLinePath = new JTextField(), java.awt.BorderLayout.CENTER);
        commandLinePath.setText (Preferences.getPreference(Preferences.TRADOS_COMMAND_LINE));
        btnBrowse = new JButton ("Find"); line3.add(btnBrowse, java.awt.BorderLayout.LINE_END);
        btnBrowse.addActionListener(evt -> {
            JFileChooser fileChooser = new JFileChooser(new File(tradosPath.getText()));
            fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY );
            fileChooser.setDialogTitle("Search for command line exe");
            fileChooser.setFileFilter (new javax.swing.filechooser.FileNameExtensionFilter( "Executable file", "exe"));
            int result = fileChooser.showOpenDialog(ExternToolsDialog.this);
            if (result == JFileChooser.APPROVE_OPTION) {
                File file = fileChooser.getSelectedFile();
                commandLinePath.setText(file.getName() + " %s");
            }
        });		
		
		line4.setLayout(new javax.swing.BoxLayout(line4, javax.swing.BoxLayout.X_AXIS));
		line4.add(bUseXcompile = new JCheckBox(OStrings.getString("EXT_TOOLS_USE_XCOMPILE")));
		bUseXcompile.setSelected (Preferences.isPreferenceDefault(Preferences.TRADOS_USE_XCOMPILE, false));
		line4.add(bKeepAfterUse = new JCheckBox(OStrings.getString("EXT_TOOLS_KEEP_PROJECT")));
		bKeepAfterUse.setSelected (Preferences.isPreferenceDefault(Preferences.TRADOS_KEEP_INTERMEDIATE, false));
		line4.add(bRenameMethod = new JCheckBox(OStrings.getString("EXT_TOOLS_RENAME_METHOD")));
		bRenameMethod.setSelected (Preferences.isPreferenceDefault(Preferences.TRADOS_RENAME_METHOD, false));		

        JPanel lineProjectsDir = new JPanel(); getContentPane().add(lineProjectsDir); 
        lineProjectsDir.setLayout (new java.awt.BorderLayout());
        lineProjectsDir.add(new JLabel(OStrings.getString("EXT_TOOLS_PROJECTS_DIR")), java.awt.BorderLayout.LINE_START);
        lineProjectsDir.add(projectsDirPath = new javax.swing.JTextField() {
            @Override public void paint(Graphics g) {
                super.paint(g);
                if (getText().length() == 0) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    int c0 = getBackground().getRGB(), c1 = getForeground().getRGB();
                    int m = 0xfefefefe;
                    int c2 = ((c0 & m) >>> 1) + ((c1 & m) >>> 1);
                    g.setColor(new Color(c2, true));
                    g.drawString(OStrings.getString("EXT_TOOLS_PROJECTS_TIP"), this.getInsets().left, this.getHeight() / 2 + g.getFontMetrics().getAscent() / 2 - 2);
                }
            }
        }, java.awt.BorderLayout.CENTER);
        if (Preferences.getPreferenceDefault(Preferences.TRADOS_PROJ_PATH, "").length() > 0) projectsDirPath.setText (Preferences.getPreference(Preferences.TRADOS_PROJ_PATH));        
        btnBrowse = new JButton ("Find"); lineProjectsDir.add(btnBrowse, java.awt.BorderLayout.LINE_END);
        btnBrowse.addActionListener(evt -> {
            JFileChooser fileChooser = new JFileChooser(projectsDirPath.getText());
            fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY); fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle("Search for Trados projects directory");
            int result = fileChooser.showOpenDialog(ExternToolsDialog.this);
            if (result == JFileChooser.APPROVE_OPTION) { 
                StringBuffer buf = new StringBuffer(); for (File f : fileChooser.getSelectedFiles()) buf.append(f.toString()).append(";");
                projectsDirPath.setText(buf.toString());
            }
        });
        
        JPanel lineFileModel = new JPanel(); getContentPane().add(lineFileModel); 
        lineFileModel.setLayout (new java.awt.BorderLayout());
        lineFileModel.add(new JLabel(OStrings.getString("EXT_TOOLS_FILE_MODEL")), java.awt.BorderLayout.LINE_START);
        lineFileModel.add(fileModel = new javax.swing.JTextField(), java.awt.BorderLayout.CENTER);
        //fileModel.setText (Preferences.getPreferenceDefault(Preferences.TRADOS_FILE_MODEL,"*.*.sdlxliff"));
        
        JPanel lineProjectsModel = new JPanel(); getContentPane().add(lineProjectsModel); 
        lineProjectsModel.setLayout (new java.awt.BorderLayout());
        lineProjectsModel.add(new JLabel(OStrings.getString("EXT_TOOLS_PROJECTS_MODEL")), java.awt.BorderLayout.LINE_START);
        lineProjectsModel.add(projectsModel = new javax.swing.JTextField(), java.awt.BorderLayout.CENTER);

        org.openide.awt.Mnemonics.setLocalizedText(okButton, OStrings.getString("BUTTON_OK")); // NOI18N
        okButton.addActionListener(evt -> { okButtonActionPerformed(evt); });

        org.openide.awt.Mnemonics.setLocalizedText(cancelButton, OStrings.getString("BUTTON_CANCEL")); // NOI18N
        cancelButton.addActionListener(evt -> { doClose(RET_CANCEL); });        

        getContentPane().add(new JPanel()); getContentPane().add(line5);
        line5.setLayout (new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));
        line5.add(okButton);  line5.add(cancelButton);
    }// </editor-fold>//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        Preferences.setPreference(Preferences.PERL_PATH, perlPath.getText());
        Preferences.setPreference(Preferences.TRADOS_PATH, tradosPath.getText());
        Preferences.setPreference(Preferences.TRADOS_COMMAND_LINE, commandLinePath.getText());
        Preferences.setPreference(Preferences.TRADOS_USE_XCOMPILE, bUseXcompile.isSelected());
        Preferences.setPreference(Preferences.TRADOS_KEEP_INTERMEDIATE, bKeepAfterUse.isSelected());
        Preferences.setPreference(Preferences.TRADOS_RENAME_METHOD, bRenameMethod.isSelected());
        Preferences.setPreference(Preferences.TRADOS_PROJ_PATH, projectsDirPath.getText());
        Preferences.setPreference(Preferences.TRADOS_PROJ_MODEL, projectsModel.getText());
        Preferences.setPreference(Preferences.TRADOS_FILE_MODEL, fileModel.getText());
    
        doClose(RET_OK);
    }//GEN-LAST:event_okButtonActionPerformed

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton, okButton;
    private javax.swing.JTextField perlPath, tradosPath, commandLinePath, projectsDirPath, fileModel, projectsModel;
	private javax.swing.JCheckBox bUseXcompile, bKeepAfterUse, bRenameMethod;
    // End of variables declaration//GEN-END:variables

    private int returnStatus = RET_CANCEL;
}
