/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2019 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.gui.editor.filter;

import java.awt.Component;
import java.util.LinkedList;
import java.util.List;

import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.core.search.CrossSourceSearcher;
import org.omegat.core.search.CrossSourceSearchResultEntry;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IEditorFilter;

/**
 * Editor filter implementation.
 * 
 * @author Alex Buloichik (alex73mail@gmail.com)
 * @author Thomas Cordonnier
 */
public class CrossSourceFilter implements IEditorFilter {
    private final List<CrossSourceSearchResultEntry> entries = new LinkedList<>();
    private FilterBarCrossSource controlComponent;
    private CrossSourceSearcher searcher;
	private int currentEntryNum;

    public CrossSourceFilter(CrossSourceSearcher searcher, int initialEntryNum) {
        this.searcher = searcher; this.currentEntryNum = initialEntryNum;
	
		for (SearchResultEntry sre: searcher.getSearchResults()) entries.add((CrossSourceSearchResultEntry) sre);		
	
        controlComponent = new FilterBarCrossSource();
        controlComponent.btnRemoveFilter.addActionListener(e -> {
                Core.getEditor().commitAndDeactivate(); // Make sure that any change done in the current segment is not lost
                Core.getEditor().removeAttachedFilter();
            });
        controlComponent.btnNext.addActionListener(e -> {
				Core.getEditor().removeAttachedFilter();
				this.currentEntryNum ++; if (currentEntryNum > entries.size()) currentEntryNum = 0;
				Core.getEditor().setFilter(this);
            });
    }

    @Override
    public boolean isSourceAsEmptyTranslation() {
        return true;
    }


    @Override
    public boolean allowed(SourceTextEntry ste) {
        return entries.get(currentEntryNum).entries().contains(ste.entryNum());
    }

    @Override
    public Component getControlComponent() {
        return controlComponent;
    }
}
