/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2010 Alex Buloichik
               2015 Aaron Madlon-Kay
               2017 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.gui.exttrans;

/**
 * Class to store machine translation result.
 * 
 * @author Alex Buloichik (alex73mail@gmail.com)
 * @author Aaron Madlon-Kay
 * @author Thomas Cordonnier
 */
public class MachineTranslationInfo {
    public final IMachineTranslation origin;
    public final Object result;
    public int position = -1;
    public long duration;
    
    public MachineTranslationInfo(IMachineTranslation origin, long start, Object result) {
        this.origin = origin;
        this.result = result;
        this.duration = System.currentTimeMillis() - start;
    }
    
    /** What appears in the MT pane: can be an exception **/
    public String getDisplayedResult() {
        try {
            Exception e = (Exception) result;
            return e.getLocalizedMessage();	// error result
        } catch (ClassCastException cce) {
            return result.toString(); // Normal result
        }
    }
    
    public boolean isException() {
        return (result != null) && (result instanceof Exception);
    }
}
