/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2017 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.gui.glossary.taas;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

import org.omegat.core.glossaries.IGlossary;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderTBX;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

import gen.taas.TaasExtractionResult;

/**
 * Project-specific TaaS glossary : can specify domain and collection
 * 
 * @author Alex Buloichik (alex73mail@gmail.com)
 * @author Thomas Cordonnier
 */
public class LocalTaaSGlossary implements IGlossary {
    private static final Logger LOGGER = Logger.getLogger(LocalTaaSGlossary.class.getName());

	private String domain;
	private String[] collections;
	
	public LocalTaaSGlossary (Properties prop) {
		this.domain = prop.getProperty("taas.domain");
		String coll = prop.getProperty("taas.collections");
		if (coll != null) {
			this.collections = coll.split(",");
		}		
	}
	
    @Override
    public List<GlossaryEntry> search(Language sLang, Language tLang, String srcText) throws Exception {
        if (!TaaSPlugin.client.isAllowed()) {
            return Collections.emptyList();
        }

        TaasExtractionResult res = TaaSPlugin.client.termExtraction(sLang, tLang, srcText, domain, collections);
        String data = TaaSPlugin.filterTaasResult(res.getTerms());
        List<GlossaryEntry> entries = GlossaryReaderTBX.read(data, false);
        Log.logDebug(LOGGER, "TaaS returns {0} glossary entries", entries.size());
        return entries;
    }
}
