/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2013 Thomas Cordonnier
               2015 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external;

import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Properties;
import java.io.File;
import java.io.FileInputStream;

import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IFilter;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.search.TextExpression;
import org.omegat.core.Core;
import org.omegat.util.Language;

/**
 * Reads two alignable files and create a translation memory
 * 
 * @author Thomas Cordonnier
 */
public class AlignFilesMemory implements IBrowsableMemory {
    private String name;
    private Map<String,PrepareTMXEntry> entries = new HashMap<String,PrepareTMXEntry>();
    
    public AlignFilesMemory(Properties config)  {
        name = config.getProperty("name"); if (name==null) name = config.getProperty("source");
        FilterMaster master = Core.getFilterMaster();
        IParseCallback parseCallback1 = new IParseCallback() {
            public void linkPrevNextSegments() {} // not used
            
            public void addEntry(String id, String path, String source, SourceTextEntry.SourceTranslationInfo traInfo, IFilter filter, List<ProtectedPart> protectedParts) {
                PrepareTMXEntry entry = traInfo.asPrepareEntry(source);
                if (id == null) id = path; else if (path != null) id += "/" + path;
                entries.put (id, entry);
            }
        };
        try {
            master.loadFile (config.getProperty("source"), new FilterContext(Core.getProject().getProjectProperties()), parseCallback1);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        IParseCallback parseCallback2 = new IParseCallback() {
            public void linkPrevNextSegments() {} // not used
            
            public void addEntry(String id, String path, String source, SourceTextEntry.SourceTranslationInfo traInfo, IFilter filter, List<ProtectedPart> protectedParts) {
                if (id == null) id = path; else if (path != null) id += "/" + path;
                PrepareTMXEntry entry = entries.get (id);
                if (entry != null) entry.translation = source;
            }
        };
        try {
            master.loadFile (config.getProperty("target"), new FilterContext(Core.getProject().getProjectProperties()), parseCallback2);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * Get the name of the provider (or engine). <br>
     * In a project you can have more than one instance of the same engine, in which case all have same result for this method
     * but a different result in {getMemoryName()}
     */
    public String getProviderName() {
        return "Aligned files";
    }


    /**
     * Get memory name, to replace the file name when displayed inside matches pane.
     * In a project you can have more than one instance of the same engine, in which case all have same result for {getProviderName()}
     * but a different result for this method.
     */
    public String getMemoryName() {
        return name;
    }
    
    public Iterable<PrepareTMXEntry> search(int numberOfResults, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch,
        TextExpression author, // NOTE: does not take DGT-specific "translator" fields, because they would be meaningless for external providers
        long dateAfter, long dateBefore) {
        return entries.values();
    }	
    
    public IEntryCursor.TMXEntriesCursor browseAllEntries() {
        return new IEntryCursor.TMXEntriesCursor(entries.values());
    }
    
    public Iterable<PrepareTMXEntry> findMatchingTranslations (Language sLang, Language tLang, String text, int minScore, int maxCount) {
        return entries.values();
    }
    
    public List<PrepareTMXEntry> getEntries() {
        return new ArrayList<PrepareTMXEntry> (entries.values());
    }
}
