/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2013 Thomas Cordonnier
               2015 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external;

import java.util.List;
import java.util.ArrayList;
import java.io.File;

import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IFilter;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.search.TextExpression;
import org.omegat.core.Core;
import org.omegat.util.Language;

/**
 * Read a bilingual file like 'po' as a translation memory
 * 
 * @author Thomas Cordonnier
 */
public class BilingualFileMemory implements IBrowsableMemory {
    private String name;
    private List<PrepareTMXEntry> entries = new ArrayList<PrepareTMXEntry>();
    
    public BilingualFileMemory(final ProjectProperties props, final File file, final boolean extTmxLevel2,
            final boolean useSlash)  {
        name = file.getPath();
        FilterMaster master = Core.getFilterMaster();
        IParseCallback parseCallback = new IParseCallback() {
            public void linkPrevNextSegments() {} // not used
            
            public void addEntry(String id, String path, String source, SourceTextEntry.SourceTranslationInfo traInfo, IFilter filter, List<ProtectedPart> protectedParts) {
                if (traInfo == null) return; // do not include untranslated segments
                if (! traInfo.isTranslated()) return;
                entries.add (traInfo.asPrepareEntry(source));
            }
        };
        try {
            master.loadFile (name, new FilterContext(Core.getProject().getProjectProperties()), parseCallback);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getMemoryName() {
        return name;
    }

    public String getProviderName() {
        return name.substring(name.lastIndexOf('.') + 1) + " file";
    }
    
    /**
     * Returns matching TMX entries
     */
    public List<PrepareTMXEntry> findMatchingTranslations (Language sLang, Language tLang, String text, int minScore, int maxCount) {
        return entries;
    }
    
    public Iterable<PrepareTMXEntry> search(int numberOfResults, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch,
        TextExpression author, // NOTE: does not take DGT-specific "translator" fields, because they would be meaningless for external providers
        long dateAfter, long dateBefore) {
        return entries;
    }	
    
    public IEntryCursor.TMXEntriesCursor browseAllEntries() {
        return new IEntryCursor.TMXEntriesCursor(entries);
    }
}
