/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2015 Thomas CORDONNIER
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external.lucene;

import java.util.*;
import java.io.*;
import java.text.*;

import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.util.TMXProp;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Field.TermVector;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.FSDirectory;

public class LuceneWriter {

    public static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);;

    private IndexWriter indexWriter;
    private NgramAnalyzer analyzer;
    private File indexDir;

    public LuceneWriter(File indexDirectory, boolean createNewTmIndex) throws IOException {
        indexDir = indexDirectory;
        indexWriter = new IndexWriter(FSDirectory.open(indexDirectory), analyzer = new NgramAnalyzer(), createNewTmIndex, IndexWriter.MaxFieldLength.UNLIMITED);
    }
    
    /*
    public LuceneWriter(Directory indexDirectory, boolean createNewTmIndex) throws IOException {
        indexWriter = new IndexWriter(indexDirectory, analyzer = new NgramAnalyzer(), createNewTmIndex, IndexWriter.MaxFieldLength.UNLIMITED);
    }
    */
    
    public void calcstopNgrams (IEntryCursor entries) throws IOException {
        analyzer.calcstopNgrams(entries, indexDir);    
    }
    
    public void indexAll (IEntryCursor entries) throws Exception {
        try {
            while (entries.next()) {
                Document doc = createDocument(entries);
                if (doc != null) indexWriter.addDocument(doc);
            }
        } finally {
            try {
                indexWriter.commit();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    
    public void close() throws Exception {
        indexWriter.close();
    }
    
    public Document createDocument(IEntryCursor tu) throws Exception {
        Document doc = new Document();
        doc.add (new Field("src", tu.getEntrySource(), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, TermVector.YES));
        if (tu.getEntryTranslation() != null) doc.add (new Field("tra", tu.getEntryTranslation(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (tu.getEntryAuthor() != null) doc.add (new Field("author", tu.getEntryAuthor(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (tu.getEntryLastModifier() != null) doc.add (new Field("changer", tu.getEntryLastModifier(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add (new Field("creationDate", dateFormat.format(new Date(tu.getEntryCreationDate())), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add (new Field("changeDate", dateFormat.format(new Date(tu.getEntryLastModificationDate())), Field.Store.YES, Field.Index.NOT_ANALYZED));		
        while (tu.nextProperty()) doc.add (new Field("prop." + tu.getCurrentPropertyName(), tu.getCurrentPropertyValue(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        return doc;
    }
    
}