/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2014 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external.rmi;

import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.core.matching.external.IEntryCursor;

import java.rmi.Remote;
import java.rmi.RemoteException;

/** Communication protocol between the client and the server **/
public interface IDistantExternalMemory extends Remote {

    /**
     * Returns server-side timestamp, to prevent too much difference with client-side one
     **/
    long timeStamp() throws RemoteException;


    /**
     * Fetches last modifications from the database
     * @param timeStamp		
     *	a <i>server-side</i> timestamp : 
     *	    the client should take care about an eventual time-unsynchronization
     *	    because the server does not know all its clients
     * @return an identifier to be sent to next methods
     **/
    String findChanges (long timeStamp) throws RemoteException;
    
    // Methods similar to IEntryCursor but with an id: you must re-inject result of findChanges(timeStamp)
    
    public boolean next(String id) throws RemoteException;
    
    public String getEntrySource(String id) throws RemoteException;
    
    public String getEntryTranslation(String id) throws RemoteException;
    
    public String getEntryAuthor(String id) throws RemoteException;
    
    public String getEntryLastModifier(String id) throws RemoteException;
    
    public long getEntryCreationDate(String id) throws RemoteException;
    
    public long getEntryLastModificationDate(String id) throws RemoteException;
    
    public String getEntryNote(String id) throws RemoteException;
    
    /** 
     * Current entry key - null for default entry 
     * To avoid setting EntryKey to serializable, return an array of strings
     **/
    public String[] getEntryKey(String id) throws RemoteException;
    
    // Update methods. 
    
    /** Register default translation. Remove if tra == null **/
    void registerDefaultTranslation(String src, String tra) throws RemoteException;
    
    /** Register alternative translation. Parameters are split because they are not serializable **/
    void registerAltTranslation(String src, String tra, String file, String id, String path, String prev, String next) throws RemoteException;
    
}
