/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2017 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.filehooks;

import java.io.File;
import java.util.zip.*;

import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.ProjectProperties;

/**
 * Hook used by sdlproj format
 * 
 * @author Thomas CORDONNIER
 */
public class SdlProjectHook implements IFileHook {
	
    public static final String SOURCE_TRADOS_DIR = "source-trados", TARGET_TRADOS_DIR = "target-trados";
	
	@Override
	public String getNativeSourceFile (String currentFile, SourceTextEntry entry) {
		currentFile = currentFile.replace("/", File.separator);
		ProjectProperties otProj = Core.getProject().getProjectProperties();
		String sourceDir = otProj.getSourceRoot();
		try { 
			try (ZipFile zipFile = new ZipFile(new File (currentFile))) {
				currentFile = currentFile.substring(sourceDir.length());
				sourceDir = otProj.getProjectRoot() + File.separator + SOURCE_TRADOS_DIR;   
				new File(sourceDir).mkdir();
				java.util.Enumeration<? extends ZipEntry> entries = zipFile.entries();
				while (entries.hasMoreElements()) {
					ZipEntry ze = entries.nextElement();
					if (ze.getName().startsWith(otProj.getTargetLanguage().getLanguage()) && ze.getName().endsWith(".sdlxliff")) {
						currentFile = sourceDir + File.separator + ze.getName().substring(ze.getName().lastIndexOf(File.separator) + 1);
						File f = new File (currentFile); if (! f.exists()) org.apache.commons.io.IOUtils.copy(zipFile.getInputStream(ze), new java.io.FileOutputStream(f));
						return XLIFF_HOOK.getNativeSourceFile(f.getCanonicalPath(), entry, otProj.getProjectRoot() + SOURCE_TRADOS_DIR + File.separator);
					}
				}
			}
		} catch (Exception e) { // all failed
			
		}
		return currentFile; 
	}

	private Exception lastCompileException = null;
	public Exception lastCompileException() { return lastCompileException; } 
	
	@Override public String getNativeTargetFile (String currentFile) { return XLIFF_HOOK.getNativeTargetFile(currentFile); }
	
	@Override 
	public void postCompile(File destDir, String midName) {
		ProjectProperties otProj = Core.getProject().getProjectProperties();
		try {
			try (ZipFile zipFile = new ZipFile(new File (destDir, midName))) {
				java.util.Enumeration<? extends ZipEntry> entries = zipFile.entries();
				while (entries.hasMoreElements()) {
					ZipEntry ze = entries.nextElement();
					if (ze.getName().startsWith(otProj.getTargetLanguage().getLanguage()) && ze.getName().endsWith(".sdlxliff")) {
						String tradosFileName = ze.getName();
						if (tradosFileName.contains("\\")) tradosFileName = tradosFileName.substring(tradosFileName.lastIndexOf("\\") + 1);
						if (tradosFileName.contains("/")) tradosFileName = tradosFileName.substring(tradosFileName.lastIndexOf("/") + 1);
						File tradosDir = new File(Core.getProject().getProjectProperties().getProjectRoot(), TARGET_TRADOS_DIR); 
						File tradosFile = new File(tradosDir, tradosFileName); tradosFile.getParentFile().mkdirs();
						org.apache.commons.io.IOUtils.copy(zipFile.getInputStream(ze), new java.io.FileOutputStream(tradosFile));
						XLIFF_HOOK.postCompile(
							tradosDir, tradosFile.getCanonicalPath().substring(tradosDir.getCanonicalPath().length() + File.separator.length()),
							otProj.getProjectRoot() + TARGET_TRADOS_DIR + File.separator);
						lastCompileException = XLIFF_HOOK.lastCompileException(); return;						
					}
				}
			}
		} catch (Exception e) {
			lastCompileException = e;
		}
	}	

}
