/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.ro;

import java.io.IOException;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.synthesis.BaseSynthesizer;
import org.languagetool.synthesis.ManualSynthesizer;

public class RomanianSynthesizer
extends BaseSynthesizer {
    private static final String RESOURCE_FILENAME = "/ro/romanian_synth.dict";
    private static final String TAGS_FILE_NAME = "/ro/romanian_tags.txt";
    private static final String USER_DICT_FILENAME = "/ro/added.txt";
    private static ManualSynthesizer manualSynthesizer;

    public RomanianSynthesizer() {
        super(RESOURCE_FILENAME, TAGS_FILE_NAME);
    }

    protected void lookup(String lemma, String posTag, List<String> results) {
        super.lookup(lemma, posTag, results);
        List manualForms = manualSynthesizer.lookup(lemma, posTag);
        if (manualForms != null) {
            results.addAll(manualForms);
        }
    }

    protected void initSynthesizer() throws IOException {
        super.initSynthesizer();
        if (manualSynthesizer == null) {
            manualSynthesizer = new ManualSynthesizer(JLanguageTool.getDataBroker().getFromResourceDirAsStream(USER_DICT_FILENAME));
        }
    }

    protected void initPossibleTags() throws IOException {
        super.initPossibleTags();
        for (String tag : manualSynthesizer.getPossibleTags()) {
            if (this.possibleTags.contains(tag)) continue;
            this.possibleTags.add(tag);
        }
    }
}

