/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.Arrays;
import org.languagetool.AnalyzedTokenReadings;

public class AnalyzedSentence {
    private final AnalyzedTokenReadings[] tokens;
    private AnalyzedTokenReadings[] nonBlankTokens;
    private int[] whPositions;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.nonBlankTokens);
        result = 31 * result + Arrays.hashCode(this.tokens);
        result = 31 * result + Arrays.hashCode(this.whPositions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzedSentence other = (AnalyzedSentence)obj;
        if (!Arrays.equals(this.nonBlankTokens, other.nonBlankTokens)) {
            return false;
        }
        if (!Arrays.equals(this.tokens, other.tokens)) {
            return false;
        }
        return Arrays.equals(this.whPositions, other.whPositions);
    }

    public AnalyzedSentence(AnalyzedTokenReadings[] tokens) {
        this.tokens = tokens;
    }

    public AnalyzedSentence(AnalyzedTokenReadings[] tokens, int[] whPositions) {
        this.tokens = tokens;
        this.setWhPositions(whPositions);
        this.getTokensWithoutWhitespace();
    }

    public final AnalyzedTokenReadings[] getTokens() {
        return this.tokens;
    }

    public final AnalyzedTokenReadings[] getTokensWithoutWhitespace() {
        if (this.nonBlankTokens == null) {
            int whCounter = 0;
            int nonWhCounter = 0;
            int[] mapping = new int[this.tokens.length + 1];
            ArrayList<AnalyzedTokenReadings> l = new ArrayList<AnalyzedTokenReadings>();
            for (AnalyzedTokenReadings token : this.tokens) {
                if (!token.isWhitespace() || token.isSentStart() || token.isSentEnd() || token.isParaEnd()) {
                    l.add(token);
                    mapping[nonWhCounter] = whCounter;
                    ++nonWhCounter;
                }
                ++whCounter;
            }
            this.setNonBlankTokens(l.toArray(new AnalyzedTokenReadings[l.size()]));
            this.setWhPositions((int[])mapping.clone());
        }
        return (AnalyzedTokenReadings[])this.nonBlankTokens.clone();
    }

    public final int getOriginalPosition(int nonWhPosition) {
        if (this.nonBlankTokens == null) {
            this.getTokensWithoutWhitespace();
        }
        return this.getWhPositions()[nonWhPosition];
    }

    public final String toString() {
        return this.toString(",");
    }

    public final String toString(String posTagDelimiter) {
        StringBuilder sb = new StringBuilder();
        for (AnalyzedTokenReadings element : this.tokens) {
            if (!element.isWhitespace()) {
                sb.append(element.getToken());
                sb.append('[');
            }
            for (int j = 0; j < element.getReadingsLength(); ++j) {
                String posTag = element.getAnalyzedToken(j).getPOSTag();
                if (element.isSentStart()) {
                    sb.append("<S>");
                    continue;
                }
                if ("SENT_END".equals(element.getAnalyzedToken(j).getPOSTag())) {
                    sb.append("</S>");
                    continue;
                }
                if ("PARA_END".equals(element.getAnalyzedToken(j).getPOSTag())) {
                    sb.append("<P/>");
                    continue;
                }
                if (element.getAnalyzedToken(j) != null && posTag == null && !element.getClass().getName().equals("org.languagetool.tagging.de.AnalyzedGermanTokenReadings")) {
                    sb.append(element.getAnalyzedToken(j).getToken());
                    continue;
                }
                if (element.isWhitespace()) continue;
                sb.append(element.getAnalyzedToken(j));
                if (j >= element.getReadingsLength() - 1) continue;
                sb.append(posTagDelimiter);
            }
            if (!element.isWhitespace()) {
                sb.append(']');
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    public final String getAnnotations() {
        StringBuilder sb = new StringBuilder();
        sb.append("Disambiguator log: \n");
        for (AnalyzedTokenReadings element : this.tokens) {
            if (element.isWhitespace() || "".equals(element.getHistoricalAnnotations())) continue;
            sb.append(element.getHistoricalAnnotations());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setWhPositions(int[] whPositions) {
        this.whPositions = whPositions;
    }

    public int[] getWhPositions() {
        return this.whPositions;
    }

    public void setNonBlankTokens(AnalyzedTokenReadings[] nonBlankTokens) {
        this.nonBlankTokens = nonBlankTokens;
    }
}

