/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import java.util.List;
import org.omegat.core.data.EntryKey;
import org.omegat.core.matching.FindMatches;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.TMXProp;

abstract class FindMatchesKeep
extends FindMatches {
    public FindMatchesKeep(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, String memoryPath, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        super(sourceTokenizer, externalMemories, memoryPath, allowSeparateSegmentMatch, searchExactlyTheSame);
    }

    public FindMatchesKeep(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        super(sourceTokenizer, externalMemories, allowSeparateSegmentMatch, searchExactlyTheSame);
    }

    protected abstract NearString lastKeptResult();

    protected abstract void doInsertion(NearString var1);

    @Override
    protected void evalEntry(EntryKey key, String source, String translation, String realSource, int totalPenalty, boolean fuzzy, NearString.MATCH_SOURCE comesFrom, String tmxName, String creator, long creationDate, String changer, long changedDate, String revisor, String note, List<TMXProp> props) {
        int similarityStem = -5;
        int similarityNoStem = -5;
        int simAdjusted = -5;
        NearString last = this.lastKeptResult();
        if (last == null) {
            switch (this.sortKey) {
                case SCORE: {
                    similarityStem = this.calcSimilarityStem(realSource) - totalPenalty;
                    if (similarityStem < this.FUZZY_MATCH_THRESHOLD) {
                        return;
                    }
                    similarityNoStem = this.calcSimilarityNoStem(realSource) - totalPenalty;
                    simAdjusted = this.calcSimilarityAdjusted(realSource) - totalPenalty;
                    break;
                }
                case SCORE_NO_STEM: {
                    similarityNoStem = this.calcSimilarityNoStem(realSource) - totalPenalty;
                    if (similarityNoStem < this.FUZZY_MATCH_THRESHOLD) {
                        return;
                    }
                    similarityStem = this.calcSimilarityStem(realSource) - totalPenalty;
                    simAdjusted = this.calcSimilarityAdjusted(realSource) - totalPenalty;
                    break;
                }
                case ADJUSTED_SCORE: {
                    simAdjusted = this.calcSimilarityAdjusted(realSource) - totalPenalty;
                    if (simAdjusted < this.FUZZY_MATCH_THRESHOLD) {
                        return;
                    }
                    similarityStem = this.calcSimilarityStem(realSource) - totalPenalty;
                    similarityNoStem = this.calcSimilarityNoStem(realSource) - totalPenalty;
                }
            }
        } else {
            switch (this.sortKey) {
                case SCORE: {
                    similarityStem = this.calcSimilarityStem(realSource) - totalPenalty;
                    if (similarityStem < last.score) {
                        return;
                    }
                    similarityNoStem = this.calcSimilarityNoStem(realSource) - totalPenalty;
                    if (similarityStem == last.score && similarityNoStem < last.scoreNoStem) {
                        return;
                    }
                    simAdjusted = this.calcSimilarityAdjusted(realSource) - totalPenalty;
                    break;
                }
                case SCORE_NO_STEM: {
                    similarityNoStem = this.calcSimilarityNoStem(realSource) - totalPenalty;
                    if (similarityNoStem < last.scoreNoStem) {
                        return;
                    }
                    similarityStem = this.calcSimilarityStem(realSource) - totalPenalty;
                    if (similarityNoStem == last.scoreNoStem && similarityStem < last.score) {
                        return;
                    }
                    simAdjusted = this.calcSimilarityAdjusted(realSource) - totalPenalty;
                    if (similarityNoStem != last.scoreNoStem || similarityStem != last.score || simAdjusted >= last.adjustedScore) break;
                    return;
                }
                case ADJUSTED_SCORE: {
                    simAdjusted = this.calcSimilarityAdjusted(realSource) - totalPenalty;
                    if (simAdjusted < last.adjustedScore) {
                        return;
                    }
                    similarityStem = this.calcSimilarityStem(realSource) - totalPenalty;
                    if (similarityStem == last.score && simAdjusted < last.adjustedScore) {
                        return;
                    }
                    similarityNoStem = this.calcSimilarityNoStem(realSource) - totalPenalty;
                    if (similarityStem != last.score || simAdjusted != last.adjustedScore || similarityNoStem >= last.scoreNoStem) break;
                    return;
                }
            }
        }
        this.doInsertion(new NearString(key, source, translation, comesFrom, fuzzy, similarityStem, similarityNoStem, simAdjusted, null, tmxName, creator, creationDate, changer, changedDate, revisor, note, props));
    }
}

