/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.omegat.core.data.EntryKey;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;

public class NearString {
    private NearString next = null;
    public EntryKey key;
    public String source;
    public String translation;
    public String note;
    public String revisor;
    public MATCH_SOURCE comesFrom;
    public boolean fuzzyMark;
    public byte[] attr;
    public String proj;
    public List<TMXProp> props;
    public String creator;
    public long creationDate;
    public String changer;
    public long changedDate;
    public final int score;
    public final int scoreNoStem;
    public final int adjustedScore;

    public NearString(EntryKey key, String source, String translation, MATCH_SOURCE comesFrom, boolean fuzzyMark, int nearScore, int nearScoreNoStem, int adjustedScore, byte[] nearData, String projName, String creator, long creationDate, String changer, long changedDate, String revisor, String note, List<TMXProp> props) {
        this.key = key;
        this.source = source;
        this.translation = translation;
        this.comesFrom = comesFrom;
        this.fuzzyMark = fuzzyMark;
        this.score = nearScore;
        this.scoreNoStem = nearScoreNoStem;
        this.adjustedScore = adjustedScore;
        this.attr = nearData;
        this.proj = projName == null ? "" : projName;
        this.props = props;
        this.creator = creator;
        this.creationDate = creationDate;
        this.changer = changer;
        this.changedDate = changedDate;
        this.revisor = revisor;
        this.note = note;
    }

    public static NearString merge(NearString ns, EntryKey key, String source, String translation, MATCH_SOURCE comesFrom, boolean fuzzyMark, int nearScore, int nearScoreNoStem, int adjustedScore, byte[] nearData, String projName, String creator, long creationDate, String changer, long changedDate, String revisor, String note, List<TMXProp> props) {
        NearString merged = new NearString(key, source, translation, comesFrom, fuzzyMark, nearScore, nearScoreNoStem, adjustedScore, nearData, projName, creator, creationDate, changer, changedDate, revisor, note, props);
        return NearString.merge(ns, merged);
    }

    public static NearString merge(NearString ns, NearString merged) {
        return NearString.merge(ns, merged, new ScoresComparator());
    }

    private static NearString merge(NearString ns, NearString merged, ScoresComparator comparator) {
        boolean first;
        int cmp = comparator.compare(merged, ns);
        boolean bl = first = cmp > 0;
        if (cmp == 0) {
            boolean bl2 = first = merged.proj.compareTo(ns.proj) < 0;
        }
        if (first) {
            merged.next = ns;
            return merged;
        }
        if (ns.next == null) {
            ns.next = merged;
            return ns;
        }
        ns.next = NearString.merge(ns.next, merged);
        return ns;
    }

    public Iterator<NearString> getMergedEntries() {
        return new Iterator<NearString>(){
            private NearString current;
            {
                this.current = NearString.this;
            }

            @Override
            public boolean hasNext() {
                return this.current.next != null;
            }

            @Override
            public NearString next() {
                this.current = this.current.next;
                return this.current;
            }
        };
    }

    public String scoresToString() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        b.append(this.score);
        b.append("/");
        b.append(this.scoreNoStem);
        b.append("/");
        b.append(this.adjustedScore);
        b.append("%)");
        return b.toString();
    }

    public int composedScoreForSorting(SORT_KEY key) {
        switch (key) {
            case SCORE: {
                return (this.score << 14) + (this.scoreNoStem << 7) + this.adjustedScore;
            }
            case SCORE_NO_STEM: {
                return (this.scoreNoStem << 14) + (this.adjustedScore << 7) + this.score;
            }
            case ADJUSTED_SCORE: {
                return (this.adjustedScore << 14) + (this.score << 7) + this.scoreNoStem;
            }
        }
        return (this.score << 14) + (this.scoreNoStem << 7) + this.adjustedScore;
    }

    public static class ScoresComparator
    implements Comparator<NearString> {
        private final SORT_KEY key;

        public ScoresComparator() {
            this.key = Preferences.getPreferenceEnumDefault("ext_tmx_sort_key", SORT_KEY.SCORE);
        }

        public ScoresComparator(SORT_KEY key) {
            this.key = key;
        }

        @Override
        public int compare(NearString o1, NearString o2) {
            int s2;
            int s1 = this.primaryScore(o1);
            if (s1 != (s2 = this.primaryScore(o2))) {
                return s1 > s2 ? 1 : -1;
            }
            s1 = this.secondaryScore(o1);
            if (s1 != (s2 = this.secondaryScore(o2))) {
                return s1 > s2 ? 1 : -1;
            }
            s1 = this.ternaryScore(o1);
            if (s1 != (s2 = this.ternaryScore(o2))) {
                return s1 > s2 ? 1 : -1;
            }
            return 0;
        }

        private int primaryScore(NearString s) {
            switch (this.key) {
                case SCORE: {
                    return s.score;
                }
                case SCORE_NO_STEM: {
                    return s.scoreNoStem;
                }
            }
            return s.adjustedScore;
        }

        private int secondaryScore(NearString s) {
            switch (this.key) {
                case SCORE: {
                    return s.scoreNoStem;
                }
                case SCORE_NO_STEM: {
                    return s.score;
                }
            }
            return s.score;
        }

        private int ternaryScore(NearString s) {
            switch (this.key) {
                case SCORE: {
                    return s.adjustedScore;
                }
                case SCORE_NO_STEM: {
                    return s.adjustedScore;
                }
            }
            return s.scoreNoStem;
        }
    }

    public static enum SORT_KEY {
        SCORE,
        SCORE_NO_STEM,
        ADJUSTED_SCORE;

    }

    public static enum MATCH_SOURCE {
        MEMORY,
        TM,
        FILES;

    }
}

