/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.omegat.core.glossaries.GlossaryEntryStore;

public class LuceneGlossaryWriter {
    private IndexWriter indexWriter;
    private Analyzer analyzer;
    private File indexDir;

    public LuceneGlossaryWriter(File indexDirectory, Analyzer analyser, boolean createNewIndex) throws IOException {
        this.indexDir = indexDirectory;
        this.analyzer = analyser;
        this.indexWriter = new IndexWriter((Directory)FSDirectory.open((File)indexDirectory), this.analyzer, createNewIndex, IndexWriter.MaxFieldLength.UNLIMITED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexAll(Iterable<GlossaryEntryStore> entries) throws Exception {
        try {
            for (GlossaryEntryStore en : entries) {
                Document doc = this.createDocument(en);
                if (doc == null) continue;
                this.indexWriter.addDocument(doc);
            }
        }
        finally {
            try {
                this.indexWriter.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void close() throws Exception {
        this.indexWriter.close();
    }

    public Document createDocument(GlossaryEntryStore gen) {
        Document doc = new Document();
        doc.add((Fieldable)new Field("src", gen.getSrcText(), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.YES));
        if (gen.getLocText() != null) {
            doc.add((Fieldable)new Field("tra", gen.getLocText(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        return doc;
    }
}

