/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.lucene;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.core.matching.external.lucene.NgramAnalyzer;

public class LuceneWriter {
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);
    private IndexWriter indexWriter;
    private NgramAnalyzer analyzer;
    private File indexDir;

    public LuceneWriter(File indexDirectory, boolean createNewTmIndex) throws IOException {
        this.indexDir = indexDirectory;
        this.analyzer = new NgramAnalyzer();
        this.indexWriter = new IndexWriter((Directory)FSDirectory.open((File)indexDirectory), (Analyzer)this.analyzer, createNewTmIndex, IndexWriter.MaxFieldLength.UNLIMITED);
    }

    public void calcstopNgrams(IEntryCursor entries) throws IOException {
        this.analyzer.calcstopNgrams(entries, this.indexDir);
    }

    public void indexAll(IEntryCursor entries) throws Exception {
        try {
            while (entries.next()) {
                Document doc = this.createDocument(entries);
                if (doc == null) continue;
                this.indexWriter.addDocument(doc);
            }
        }
        finally {
            try {
                this.indexWriter.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void close() throws Exception {
        this.indexWriter.close();
    }

    public Document createDocument(IEntryCursor tu) throws Exception {
        Document doc = new Document();
        doc.add((Fieldable)new Field("src", tu.getEntrySource(), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.YES));
        if (tu.getEntryTranslation() != null) {
            doc.add((Fieldable)new Field("tra", tu.getEntryTranslation(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (tu.getEntryAuthor() != null) {
            doc.add((Fieldable)new Field("author", tu.getEntryAuthor(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (tu.getEntryLastModifier() != null) {
            doc.add((Fieldable)new Field("changer", tu.getEntryLastModifier(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        doc.add((Fieldable)new Field("creationDate", dateFormat.format(new Date(tu.getEntryCreationDate())), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field("changeDate", dateFormat.format(new Date(tu.getEntryLastModificationDate())), Field.Store.YES, Field.Index.NOT_ANALYZED));
        while (tu.nextProperty()) {
            doc.add((Fieldable)new Field("prop." + tu.getCurrentPropertyName(), tu.getCurrentPropertyValue(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        return doc;
    }
}

