/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.util.TMXProp;

public class FileSearchResultEntry
extends SearchResultEntry {
    private File m_file;
    private String m_src;
    private String m_target;
    private String m_comment;
    private List<SearchMatch> m_srcMatch;

    public FileSearchResultEntry(File theFile, String src, String target, String comment, List<SearchMatch> srcMatch) {
        this.m_srcMatch = srcMatch;
        this.m_file = theFile;
        this.m_src = src;
        this.m_target = target;
        this.m_comment = comment;
    }

    @Override
    public int getEntryNum() {
        return -5;
    }

    @Override
    public String getPreamble() {
        return this.m_file.getName() + this.getMoreString();
    }

    @Override
    public String getFileName() {
        return this.m_file.getName();
    }

    @Override
    public String getSrcText() {
        return this.m_src;
    }

    @Override
    public String getTranslation() {
        return this.m_target;
    }

    @Override
    public String getAuthor() {
        return "";
    }

    @Override
    public String getRevisor() {
        return null;
    }

    @Override
    public Date getDate() {
        return new Date(this.m_file.lastModified());
    }

    @Override
    public List<TMXProp> getProperties() {
        return Collections.emptyList();
    }

    @Override
    public String getNote() {
        return "";
    }

    @Override
    public boolean equals(SearchResultEntry other) {
        return super.equals(other) && this.getFileName().equals(other.getFileName());
    }

    @Override
    public List<SearchMatch> getSrcMatch() {
        return this.m_srcMatch;
    }

    @Override
    public List<SearchMatch> getTargetMatch() {
        return null;
    }

    @Override
    public List<SearchMatch> getNoteMatch() {
        return null;
    }
}

