/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.util.TMXProp;

public class PreTranslateSearchResultEntry
extends SearchResultEntry {
    private List<SearchMatch> m_highlights;
    private String m_result;
    private List<SearchMatch> m_srcMatch;
    private SourceTextEntry m_sourceEntry;
    private TMXEntry m_tmxEntry;

    public PreTranslateSearchResultEntry(SourceTextEntry sourceEntry, TMXEntry traEntry, List<SearchMatch> srcMatch) {
        this.m_srcMatch = srcMatch;
        this.m_tmxEntry = traEntry;
        this.m_sourceEntry = sourceEntry;
    }

    public PreTranslateSearchResultEntry(SourceTextEntry sourceEntry, TMXEntry traEntry, List<SearchMatch> srcMatch, List<SearchMatch> highlights, String pretranslatedText) {
        this(sourceEntry, traEntry, srcMatch);
        this.m_highlights = highlights;
        this.m_result = pretranslatedText;
    }

    public PreTranslateSearchResultEntry(PreTranslateSearchResultEntry copy, List<SearchMatch> srcMatch, List<SearchMatch> highlights) {
        this(copy.m_sourceEntry, copy.m_tmxEntry, srcMatch, highlights, copy.m_result);
    }

    public List<SearchMatch> getHighlights() {
        return this.m_highlights;
    }

    public String getTranslationResult() {
        return this.m_result;
    }

    void setHighlights(List<SearchMatch> highlights) {
        this.m_highlights = highlights;
    }

    void addHighlight(int start, int end, boolean error) {
        if (this.m_highlights == null) {
            this.m_highlights = new ArrayList<SearchMatch>();
        }
        this.m_highlights.add(new SearchMatch(start, end));
    }

    void setTranslationResult(String tra) {
        this.m_result = tra;
    }

    public void setAllHighlights(List<SearchMatch> src, List<SearchMatch> tra) {
        this.m_highlights = tra;
        this.m_srcMatch = src;
    }

    @Override
    public int getEntryNum() {
        return this.m_sourceEntry.entryNum();
    }

    @Override
    public String getPreamble() {
        return "" + this.getEntryNum() + this.getMoreString();
    }

    @Override
    public String getSrcText() {
        return this.m_sourceEntry.getSrcText();
    }

    @Override
    public String getTranslation() {
        return this.m_tmxEntry.translation == null ? "" : this.m_tmxEntry.translation;
    }

    @Override
    public String getNote() {
        return this.m_tmxEntry.note == null ? "" : this.m_tmxEntry.note;
    }

    @Override
    public String getFileName() {
        return this.m_sourceEntry.getKey().file;
    }

    @Override
    public String getAuthor() {
        return this.m_tmxEntry.creator == null ? "" : this.m_tmxEntry.creator;
    }

    @Override
    public Date getDate() {
        return new Date(this.m_tmxEntry.creationDate);
    }

    @Override
    public List<TMXProp> getProperties() {
        return Collections.emptyList();
    }

    @Override
    public String getRevisor() {
        return this.m_tmxEntry.revisor;
    }

    @Override
    public List<SearchMatch> getSrcMatch() {
        return this.m_srcMatch;
    }

    @Override
    public List<SearchMatch> getTargetMatch() {
        return null;
    }

    @Override
    public List<SearchMatch> getNoteMatch() {
        return null;
    }
}

