/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IStopped;
import org.omegat.core.machinetranslators.dummy.SourceTranslate;
import org.omegat.core.matching.FindMatchesSingleton;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.core.search.PreTranslateSearchResultEntry;
import org.omegat.core.search.ProjectSearcher;
import org.omegat.core.search.ReplaceMatch;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SourceSearchResultEntry;
import org.omegat.core.search.TextExpression;
import org.omegat.core.search.TranslationStateFilter;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.gui.search.PreTranslateDialog;
import org.omegat.gui.search.SearchVarExpansion;
import org.omegat.util.Language;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class PreTranslateSearcher
extends ProjectSearcher
implements IStopped {
    public static final byte TRANSLATE_ENTIRE = 0;
    public static final byte TRANSLATE_WHOLE = 1;
    public static final byte TRANSLATE_FOUND = 2;
    private Iterator<SourceTextEntry> iter = null;
    private String m_prefix;
    private IMachineTranslation m_replaceContent;
    protected final TextExpression m_searchSource;
    protected final TranslationStateFilter m_translationStateFilter;
    private boolean m_asAlternative;

    public PreTranslateSearcher(IProject project, PreTranslateDialog window, int numberOfResults, boolean asAlternative, TextExpression searchSource, TranslationStateFilter filter, IMachineTranslation translator, String prefix, TextExpression author, long dateAfter, long dateBefore) {
        super(window, project, !asAlternative, false, numberOfResults, author, null, dateAfter, dateBefore);
        this.m_prefix = prefix;
        this.m_searchSource = searchSource;
        this.m_translationStateFilter = filter;
        this.m_replaceContent = translator;
        this.m_asAlternative = asAlternative;
    }

    @Override
    public boolean isStopped() {
        return this.isInterrupted();
    }

    public IMachineTranslation buildTranslationMemoriesPreTranslator(final NearString.SORT_KEY criteria, final int minValue, final String memoryPath) {
        return new IMachineTranslation(){
            FindMatchesSingleton matches;
            {
                this.matches = new FindMatchesSingleton(PreTranslateSearcher.this.m_project.getSourceTokenizer(), new IExternalMemory[0], memoryPath, false, false);
            }

            @Override
            public String getName() {
                return "***TranslationMemory***";
            }

            @Override
            public String getTranslation(Language sLang, Language tLang, String text) {
                NearString best = this.matches.search(PreTranslateSearcher.this.m_project, text, true, false, PreTranslateSearcher.this);
                if (best == null) {
                    return null;
                }
                switch (criteria) {
                    case SCORE: {
                        if (best.score >= minValue) break;
                        return null;
                    }
                    case SCORE_NO_STEM: {
                        if (best.scoreNoStem >= minValue) break;
                        return null;
                    }
                    case ADJUSTED_SCORE: {
                        if (best.adjustedScore >= minValue) break;
                        return null;
                    }
                }
                String tra = best.translation;
                if (Preferences.isPreference("wf_convertNumbers")) {
                    tra = Core.getMatcher().substituteNumbers(text, best.source, tra);
                }
                String prefix = PreTranslateSearcher.this.m_prefix;
                prefix = prefix.replace("${score}", Integer.toString(best.score));
                prefix = prefix.replace("${noStemScore}", Integer.toString(best.scoreNoStem));
                prefix = prefix.replace("${adjustedScore}", Integer.toString(best.adjustedScore));
                prefix = prefix.replace("${file}", best.proj);
                prefix = prefix.replace("${author}", best.creator);
                return prefix + tra;
            }
        };
    }

    public IMachineTranslation buildReplacerPreTranslator(String replacement, byte replaceMode, boolean replaceVars) {
        return new ReplaceTextMachineTranslation(replacement, replaceMode, replaceVars);
    }

    public void setTranslator(IMachineTranslation tra) {
        this.m_replaceContent = tra;
    }

    protected PreTranslateSearchResultEntry buildOngoingEntry(SourceTextEntry ste, TMXEntry tmxEntry, List<SearchMatch> srcMatches) {
        PreTranslateSearchResultEntry entry = new PreTranslateSearchResultEntry(ste, tmxEntry, srcMatches);
        try {
            ((ReplaceTextMachineTranslation)this.m_replaceContent).reset(ste);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String translation = this.m_replaceContent.getTranslation(Core.getProject().getProjectProperties().getSourceLanguage(), Core.getProject().getProjectProperties().getTargetLanguage(), ste.getSrcText());
            if (translation == null) {
                return null;
            }
            if (this.m_replaceContent.getName().equals("Source with glossaries")) {
                ((SourceTranslate)this.m_replaceContent).rebuildEntryHighlights(entry, translation, this.m_prefix);
            }
            if (!this.m_replaceContent.getName().equals("***TranslationMemory***")) {
                translation = this.m_prefix + translation;
            }
            entry.setTranslationResult(translation);
            if (this.m_replaceContent instanceof ReplaceTextMachineTranslation) {
                entry.setHighlights(((ReplaceTextMachineTranslation)this.m_replaceContent).findSubpart.searchString(translation));
            } else {
                if (entry.getHighlights() == null) {
                    entry.setHighlights(new ArrayList<SearchMatch>());
                }
                if (this.m_prefix.contains("$")) {
                    for (SearchMatch m : new TextExpression.RegexTextExpression("^\\[(.+?)\\]", true).searchString(translation)) {
                        entry.addHighlight(m.getStart(), m.getEnd(), false);
                    }
                } else if (this.m_prefix.length() > 0) {
                    entry.addHighlight(0, this.m_prefix.length(), false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            entry.setTranslationResult("[ERROR] " + e.getMessage());
            entry.addHighlight(0, 7, true);
        }
        return entry;
    }

    @Override
    protected void testOngoing(SourceTextEntry ste) {
        PreTranslateSearchResultEntry entry;
        TMXEntry tmxEntry = this.m_project.getTranslationInfo(ste);
        if (!this.getTranslationStateFilter().isValidEntry(tmxEntry)) {
            return;
        }
        if (!this.checkFilters(tmxEntry)) {
            return;
        }
        List<SearchMatch> srcMatches = this.m_searchSource.searchString(ste.getSrcText());
        if (srcMatches != null && (entry = this.buildOngoingEntry(ste, tmxEntry, srcMatches)) != null) {
            this.addEntry(entry);
        }
    }

    public PreTranslateSearchResultEntry testSingleEntry(SourceTextEntry ste) {
        TMXEntry tmxEntry = this.m_project.getTranslationInfo(ste);
        if (!this.getTranslationStateFilter().isValidEntry(tmxEntry)) {
            return null;
        }
        if (!this.checkFilters(tmxEntry)) {
            return null;
        }
        List<SearchMatch> srcMatches = this.m_searchSource.searchString(ste.getSrcText());
        if (srcMatches != null) {
            return this.buildOngoingEntry(ste, tmxEntry, srcMatches);
        }
        return null;
    }

    public String replaceOccurence(String oriText, int pos, SourceTextEntry ste) {
        try {
            ProjectProperties prop = this.m_project.getProjectProperties();
            return this.m_prefix + this.m_replaceContent.getTranslation(prop.getSourceLanguage(), prop.getTargetLanguage(), oriText);
        }
        catch (Exception e) {
            return oriText;
        }
    }

    @Override
    public TranslationStateFilter getTranslationStateFilter() {
        return this.m_translationStateFilter;
    }

    @Override
    public boolean searchOn(int location) {
        return (location & 1) > 0;
    }

    public List<SearchMatch> searchInSource(String text) {
        return this.m_searchSource == null ? null : this.m_searchSource.searchString(text);
    }

    @Override
    public Iterator<SourceTextEntry> projectEntries() {
        if (this.iter == null) {
            this.iter = this.m_project.getAllEntries().iterator();
        }
        return this.iter;
    }

    public void startAt(Iterator<SourceTextEntry> iter) {
        this.iter = iter;
    }

    public boolean translateAsAlternative() {
        return this.m_asAlternative;
    }

    private class ReplaceTextMachineTranslation
    implements IMachineTranslation {
        private String replacement;
        private boolean m_replaceVars;
        private byte m_replaceMode;
        public final TextExpression.RegexTextExpression findSubpart;
        private SearchVarExpansion varExpansion;
        private final char[] ESCAPE_REGEX = new char[]{'*', '+', '[', ']', '(', ')'};

        public ReplaceTextMachineTranslation(String replacement, byte replaceMode, boolean replaceVars) {
            this.m_replaceMode = replaceMode;
            this.m_replaceVars = replaceVars;
            this.varExpansion = this.m_replaceVars && replacement.contains("${") ? new SearchVarExpansion(Core.getProject().getProjectProperties(), replacement) : null;
            this.replacement = replacement;
            if (this.m_replaceVars) {
                replacement = replacement.replaceAll("(?<!\\\\)\\$\\{(\\w+)\\}", "!<$1>");
            }
            if (!replaceVars) {
                this.findSubpart = new TextExpression.RegexTextExpression(this.escapeRegexChars(replacement).replace("$", "\\$"), true);
            } else if (!replacement.contains("$")) {
                this.findSubpart = new TextExpression.RegexTextExpression(this.escapeRegexChars(replacement), true);
            } else if (PreTranslateSearcher.this.m_searchSource instanceof TextExpression.ExactTokenExpression) {
                this.findSubpart = new TextExpression.RegexTextExpression(this.escapeRegexChars(replacement).replaceAll("(?<!\\\\)\\$\\d+", "(\\\\p{L}+)"), true);
            } else if (PreTranslateSearcher.this.m_searchSource instanceof TextExpression.RegexTextExpression) {
                String pattern = ((TextExpression.RegexTextExpression)PreTranslateSearcher.this.m_searchSource).getPattern().pattern();
                Matcher m = Pattern.compile("\\((.+?)\\)").matcher(pattern);
                ArrayList<String> groups = new ArrayList<String>();
                while (m.find()) {
                    groups.add(m.group(1));
                }
                StringBuffer buf = new StringBuffer();
                String copy = this.escapeRegexChars(replacement);
                while (copy.contains("$")) {
                    buf.append(copy.substring(0, copy.indexOf("$")));
                    copy = copy.substring(copy.indexOf("$"));
                    m = Pattern.compile("(?<!\\\\)\\$(\\d+)").matcher(copy);
                    if (m.find()) {
                        int id = Integer.parseInt(m.group(1));
                        if (id == 0) {
                            buf.append("(" + pattern + ")");
                        } else if (groups.size() > id) {
                            buf.append("(").append((String)groups.get(id - 1)).append(")");
                        } else {
                            buf.append("(\\S+)");
                        }
                        copy = copy.substring(m.group(0).length());
                        continue;
                    }
                    buf.append("\\$");
                    copy = copy.substring(1);
                }
                buf.append(copy);
                this.findSubpart = new TextExpression.RegexTextExpression(buf.toString(), true);
            } else {
                this.findSubpart = new TextExpression.RegexTextExpression(replacement, true);
            }
        }

        private String escapeRegexChars(String ori) {
            for (char ch : this.ESCAPE_REGEX) {
                ori = ori.replace("" + ch, "\\" + ch);
            }
            return ori;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public String getTranslation(Language sLang, Language tLang, String oriText) {
            if (this.m_replaceMode == 0) {
                if (!this.m_replaceVars) {
                    return this.replacement;
                }
                List<SearchMatch> matches = PreTranslateSearcher.this.m_searchSource.searchString(oriText);
                String repl = this.replacement;
                boolean found = false;
                Matcher replaceMatcher = Pattern.compile("(?<!\\\\)\\$\\^(\\d+)").matcher(repl);
                while (replaceMatcher.find()) {
                    int varId = Integer.parseInt(replaceMatcher.group(1));
                    repl = replaceMatcher.replaceFirst(oriText.substring(matches.get(varId - 1).getStart(), matches.get(varId - 1).getEnd()));
                    replaceMatcher.reset(repl);
                    found = true;
                }
                if (found) {
                    return StringUtil.replaceCase(repl, Core.getProject().getProjectProperties().getTargetLanguage().getLocale());
                }
                try {
                    return ((ReplaceMatch)matches.get(0)).getReplacement();
                }
                catch (Exception e) {
                    return this.replacement;
                }
            }
            List<SearchMatch> matches = PreTranslateSearcher.this.m_searchSource.searchString(oriText);
            if (this.m_replaceMode == 1) {
                ArrayList<SearchMatch> englobedList = new ArrayList<SearchMatch>(matches.size());
                for (SearchMatch m : matches) {
                    englobedList.add(m.englobeWord(oriText));
                }
                matches = englobedList;
            }
            return ReplaceMatch.buildReplacedString(oriText, matches, this.replacement);
        }

        public void reset(SourceTextEntry ste) {
            if (this.varExpansion != null) {
                this.replacement = this.varExpansion.apply(new SourceSearchResultEntry(ste, null, null, null));
            }
        }
    }
}

