/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.Iterator;
import java.util.List;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.ProjectSearcher;
import org.omegat.core.search.ReplaceSearchResultEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.TextExpression;
import org.omegat.core.search.TranslationStateFilter;
import org.omegat.gui.search.ReplaceDialog;

public class ReplaceSearcher
extends ProjectSearcher {
    private Iterator<SourceTextEntry> iter = null;
    protected final TextExpression m_searchTarget;
    private boolean m_orphans;

    public ReplaceSearcher(ReplaceDialog window, IProject project, int numberOfResults, boolean withOrphans, TextExpression searchTarget, TextExpression author, TextExpression translator, long dateAfter, long dateBefore) {
        super(window, project, true, false, numberOfResults, author, null, dateAfter, dateBefore);
        this.m_searchTarget = searchTarget;
        this.m_orphans = withOrphans;
    }

    @Override
    protected void testOngoing(SourceTextEntry ste) {
        TMXEntry tmxEntry = this.m_project.getTranslationInfo(ste);
        if (!this.getTranslationStateFilter().isValidEntry(tmxEntry)) {
            return;
        }
        if (!this.checkFilters(tmxEntry)) {
            return;
        }
        List<SearchMatch> targetMatches = this.m_searchTarget.searchString(tmxEntry.translation);
        if (targetMatches != null) {
            this.addEntry(new ReplaceSearchResultEntry(ste, tmxEntry, targetMatches));
        }
    }

    @Override
    public TranslationStateFilter getTranslationStateFilter() {
        return TranslationStateFilter.TRANSLATED_ONLY;
    }

    @Override
    public boolean searchOn(int location) {
        if ((location & 2) > 0) {
            return this.m_orphans;
        }
        return (location & 1) > 0;
    }

    public List<SearchMatch> searchInTranslation(String text) {
        return this.m_searchTarget == null ? null : this.m_searchTarget.searchString(text);
    }

    @Override
    public Iterator<SourceTextEntry> projectEntries() {
        if (this.iter == null) {
            this.iter = this.m_project.getAllEntries().iterator();
        }
        return this.iter;
    }

    public void startAt(Iterator<SourceTextEntry> iter) {
        this.iter = iter;
    }
}

