/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.List;
import org.omegat.core.search.ReplaceMatch;

public class SearchMatch
implements Comparable<SearchMatch> {
    protected int start;
    protected int end;

    public SearchMatch(int start, int end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public int compareTo(SearchMatch o) {
        int diff = this.start - o.start;
        if (diff == 0) {
            diff = this.end - o.end;
        }
        return diff;
    }

    public SearchMatch merge(SearchMatch other, boolean mustKeep, String defaultReplacement) {
        try {
            return new ReplaceMatch(Math.min(this.start, other.start), Math.max(this.end, other.end), defaultReplacement + ((ReplaceMatch)other).getReplacement());
        }
        catch (ClassCastException cce) {
            if (defaultReplacement != null) {
                return new ReplaceMatch(Math.min(this.start, other.start), Math.max(this.end, other.end), defaultReplacement + defaultReplacement);
            }
            if (mustKeep) {
                return new SearchMatch(Math.min(this.start, other.start), Math.max(this.end, other.end));
            }
            this.start = Math.min(this.start, other.start);
            this.end = Math.max(this.end, other.end);
            return this;
        }
    }

    public static void collapse(List<SearchMatch> foundMatches, String defaultReplacement) {
        int i = 1;
        while (i < foundMatches.size()) {
            SearchMatch pr = foundMatches.get(i - 1);
            SearchMatch cu = foundMatches.get(i);
            if (pr.getStart() <= cu.getStart() && pr.getEnd() >= cu.getStart()) {
                foundMatches.set(i - 1, pr.merge(cu, false, defaultReplacement));
                foundMatches.remove(i);
                continue;
            }
            ++i;
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public int addLength(int count) {
        return this.end += count;
    }

    public void move(int offset) {
        this.start += offset;
        this.end += offset;
    }

    public SearchMatch englobeWord(String source) {
        int newStart;
        int newEnd = this.end;
        if (Character.isLetter(source.charAt(this.start))) {
            for (newStart = this.start; newStart > 0 && Character.isLetter(source.charAt(newStart - 1)); --newStart) {
            }
        }
        if (this.end > 0 && Character.isLetter(source.charAt(this.end - 1))) {
            while (newEnd < source.length() && Character.isLetter(source.charAt(newEnd))) {
                ++newEnd;
            }
        }
        return new SearchMatch(newStart, newEnd);
    }
}

