/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.Date;
import java.util.List;
import org.omegat.core.search.SearchMatch;
import org.omegat.util.OStrings;
import org.omegat.util.TMXProp;

public abstract class SearchResultEntry
implements Comparable<SearchResultEntry> {
    private int more = 0;

    public abstract int getEntryNum();

    public abstract String getPreamble();

    public abstract String getSrcText();

    public abstract String getTranslation();

    public abstract String getNote();

    public abstract String getFileName();

    public abstract String getAuthor();

    public abstract String getRevisor();

    public abstract Date getDate();

    public abstract List<TMXProp> getProperties();

    public abstract List<SearchMatch> getSrcMatch();

    public abstract List<SearchMatch> getTargetMatch();

    public abstract List<SearchMatch> getNoteMatch();

    public boolean equals(SearchResultEntry entry) {
        if (!entry.getSrcText().equals(this.getSrcText())) {
            return false;
        }
        if (this.getTranslation() == null) {
            return entry.getTranslation() == null;
        }
        return this.getTranslation().equals(entry.getTranslation());
    }

    @Override
    public final int compareTo(SearchResultEntry other) {
        if (this.getEntryNum() > 0) {
            if (other.getEntryNum() > 0) {
                return this.getEntryNum() - other.getEntryNum();
            }
            return -1;
        }
        if (other.getEntryNum() > 0) {
            return 1;
        }
        return this.compareContents(other);
    }

    protected int compareContents(SearchResultEntry other) {
        int compare = this.getFileName().compareTo(other.getFileName());
        if (compare != 0) {
            return compare;
        }
        compare = this.getSrcText().compareTo(other.getSrcText());
        if (compare != 0) {
            return compare;
        }
        if (this.getTranslation() != null && other.getTranslation() != null) {
            compare = this.getTranslation().compareTo(other.getTranslation());
        }
        return 0;
    }

    void addMore() {
        ++this.more;
    }

    public final String getMoreString() {
        if (this.more == 0) {
            return "";
        }
        return "\u00a0(" + OStrings.getString("SW_NR_OF_MORE").replace("{0}", Integer.toString(this.more)) + ")";
    }
}

