/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filehooks;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.SimpleBindings;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.filehooks.IFileHook;
import org.omegat.gui.scripting.ScriptRunner;
import org.omegat.util.Preferences;

public class ReformatterHook
implements IFileHook {
    private static CompiledScript groovyReformatter = null;

    @Override
    public String getNativeSourceFile(String currentFile, SourceTextEntry entry) {
        return currentFile;
    }

    @Override
    public boolean supportsPseudoTags() {
        return true;
    }

    @Override
    public boolean isNotToCompile(String midName) {
        return midName.toLowerCase().endsWith(".docx") && midName.contains("~$");
    }

    @Override
    public void postCompile(File destDir, String midName) {
        block4: {
            try {
                File tmpDestFile = new File(destDir, midName);
                ScriptEngine groovy = ScriptRunner.MANAGER.getEngineByExtension("groovy");
                SimpleBindings bindings = new SimpleBindings();
                bindings.put("project", (Object)Core.getProject());
                bindings.put("console", (Object)System.console());
                bindings.put("fileName", (Object)tmpDestFile.getPath());
                System.err.println("Start reformat.groovy " + tmpDestFile.getPath());
                groovy.eval((Reader)new FileReader(Preferences.getPreferenceDefault("scripts_dir", System.getenv("OMEGAT_HOME") + File.separator + "scripts") + File.separator + "extra" + File.separator + "reformat.groovy"), (Bindings)bindings);
                System.err.println("End reformat.groovy " + tmpDestFile.getPath());
                String extension = midName.substring(midName.lastIndexOf(46));
                File italics = new File(tmpDestFile.getPath().replace(extension, "-italic" + extension));
                if (!italics.exists()) break block4;
                File locRootDirUnf = new File(tmpDestFile.getParentFile().getParentFile(), "target-unfiltered");
                File fileUnf = new File(locRootDirUnf.getPath() + File.separator + midName);
                fileUnf.getParentFile().mkdirs();
                try {
                    Files.move(tmpDestFile.toPath(), fileUnf.toPath(), new CopyOption[0]);
                }
                catch (Exception eMov) {
                    tmpDestFile.delete();
                }
                italics.renameTo(tmpDestFile);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }
}

