/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.omegat.gui.editor.ModificationInfoManager;
import org.omegat.gui.editor.ParagraphMarkerVarExpansion;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.RegexHighlightListener;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class ViewOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton cancelButton;
    private JButton insertButton;
    private JButton insertButtonND;
    private JCheckBox markFirstNonUnique;
    private JTextField modInfoTemplate;
    private JTextField modInfoTemplateND;
    private JButton okButton;
    private JCheckBox simplifyPPTooltips;
    private JCheckBox templateActivator;
    private JLabel templateLabel;
    private JLabel templateLabelND;
    private JLabel variablesLabel;
    private JLabel variablesLabelND;
    private JComboBox variablesList;
    private JComboBox variablesListND;
    private JCheckBox viewSourceAllBold;
    private JCheckBox libeBreaks;
    private JCheckBox dispOrigin;
    private JCheckBox colorTyping;
    private JRadioButton startEndSegment;
    private JRadioButton endOnlySegment;
    JTextField paraMarkText;
    private int returnStatus = 0;

    public ViewOptionsDialog(Frame parent) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.viewSourceAllBold.setSelected(Preferences.isPreferenceDefault("view_option_source_all_bold", true));
        this.markFirstNonUnique.setSelected(Preferences.isPreference("view_option_unique_first"));
        this.simplifyPPTooltips.setSelected(Preferences.isPreferenceDefault("view_option_ppt_simplify", true));
        this.templateActivator.setSelected(Preferences.isPreferenceDefault("view_option_template_active", false));
        this.templatesSetEnabled(this.templateActivator.isSelected());
        this.modInfoTemplate.setText(Preferences.getPreferenceDefault("view_option_mod_info_template", "${creationId} - ${changedId} ${changedDate} ${changedTime}"));
        this.modInfoTemplate.setCaretPosition(0);
        this.modInfoTemplateND.setText(Preferences.getPreferenceDefault("view_option_mod_info_template_wo_date", "${creationId} - ${changedId}"));
        this.modInfoTemplateND.setCaretPosition(0);
        this.invalidate();
        this.pack();
        DockingUI.displayCentered(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.viewSourceAllBold = new JCheckBox();
        this.markFirstNonUnique = new JCheckBox();
        this.templateLabel = new JLabel();
        this.modInfoTemplate = new JTextField();
        this.variablesLabel = new JLabel();
        this.variablesList = new JComboBox();
        this.insertButton = new JButton();
        this.templateLabelND = new JLabel();
        this.modInfoTemplateND = new JTextField();
        this.variablesLabelND = new JLabel();
        this.variablesListND = new JComboBox();
        this.insertButtonND = new JButton();
        this.simplifyPPTooltips = new JCheckBox();
        this.templateActivator = new JCheckBox();
        this.setTitle(OStrings.getString("VIEW_OPTION_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ViewOptionsDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.viewSourceAllBold.setSelected(true);
        Mnemonics.setLocalizedText(this.viewSourceAllBold, OStrings.getString("VIEW_OPTION_SOURCE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.viewSourceAllBold, gridBagConstraints);
        Mnemonics.setLocalizedText(this.markFirstNonUnique, OStrings.getString("VIEW_OPTION_UNIQUE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.markFirstNonUnique, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/omegat/Bundle");
        Mnemonics.setLocalizedText(this.templateLabel, bundle.getString("MOD_INFO_TEMPLATE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.templateLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.getContentPane().add((Component)this.modInfoTemplate, gridBagConstraints);
        this.modInfoTemplate.getDocument().addDocumentListener(new RegexHighlightListener(this.modInfoTemplate, 32));
        Mnemonics.setLocalizedText(this.variablesLabel, bundle.getString("MOD_INFO_TEMPLATE_VARIABLES"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.getContentPane().add((Component)this.variablesLabel, gridBagConstraints);
        this.variablesList.setModel(new DefaultComboBoxModel<String>(ModificationInfoManager.MOD_INFO_VARIABLES));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.getContentPane().add((Component)this.variablesList, gridBagConstraints);
        Mnemonics.setLocalizedText(this.insertButton, bundle.getString("BUTTON_INSERT"));
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewOptionsDialog.this.insertButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.getContentPane().add((Component)this.insertButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.templateLabelND, bundle.getString("MOD_INFO_TEMPLATE_NO_DATE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.templateLabelND, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.getContentPane().add((Component)this.modInfoTemplateND, gridBagConstraints);
        this.modInfoTemplateND.getDocument().addDocumentListener(new RegexHighlightListener(this.modInfoTemplateND, 32));
        Mnemonics.setLocalizedText(this.variablesLabelND, bundle.getString("MOD_INFO_TEMPLATE_VARIABLES"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.variablesLabelND, gridBagConstraints);
        this.variablesListND.setModel(new DefaultComboBoxModel<String>(ModificationInfoManager.MOD_INFO_VARIABLES_NO_DATE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.getContentPane().add((Component)this.variablesListND, gridBagConstraints);
        Mnemonics.setLocalizedText(this.insertButtonND, bundle.getString("BUTTON_INSERT"));
        this.insertButtonND.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewOptionsDialog.this.insertButtonNDActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.getContentPane().add((Component)this.insertButtonND, gridBagConstraints);
        Mnemonics.setLocalizedText(this.simplifyPPTooltips, OStrings.getString("VIEW_OPTION_PPT_SIMPLIFY"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.simplifyPPTooltips, gridBagConstraints);
        Mnemonics.setLocalizedText(this.templateActivator, OStrings.getString("MOD_INFO_TEMPLATE_ACTIVATOR"));
        this.templateActivator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewOptionsDialog.this.templateActivatorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.templateActivator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)new JLabel(OStrings.getString("VIEW_OPTION_EDITION_ZONE")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.endOnlySegment = new JRadioButton(OStrings.getString("VIEW_OPTION_END_SEGMENT"));
        this.getContentPane().add((Component)this.endOnlySegment, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.startEndSegment = new JRadioButton(OStrings.getString("VIEW_OPTION_START_END_SEGMENT"));
        this.getContentPane().add((Component)this.startEndSegment, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.libeBreaks = new JCheckBox(OStrings.getString("VIEW_OPTION_LINE_BREAKS"));
        this.getContentPane().add((Component)this.libeBreaks, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dispOrigin = new JCheckBox(OStrings.getString("VIEW_OPTION_DISP_ORIGIN"));
        this.getContentPane().add((Component)this.dispOrigin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.colorTyping = new JCheckBox(OStrings.getString("VIEW_OPTION_COLOR_TYPING"));
        this.getContentPane().add((Component)this.colorTyping, gridBagConstraints);
        this.endOnlySegment.setSelected(!Preferences.isPreferenceDefault("view_editor_zone_start_end", true));
        this.startEndSegment.setSelected(Preferences.isPreferenceDefault("view_editor_zone_start_end", true));
        this.libeBreaks.setSelected(Preferences.isPreferenceDefault("view_editor_zone_line_breaks", true));
        this.dispOrigin.setSelected(Preferences.isPreferenceDefault("view_editor_zone_display_origin", true));
        this.colorTyping.setSelected(Preferences.isPreferenceDefault("view_editor_zone_blank_typing", false));
        ButtonGroup ourButtonGroup = new ButtonGroup();
        ourButtonGroup.add(this.endOnlySegment);
        ourButtonGroup.add(this.startEndSegment);
        JLabel paraMarkLabel = new JLabel();
        paraMarkLabel.setLabelFor(this.paraMarkText);
        Mnemonics.setLocalizedText(paraMarkLabel, OStrings.getString("WG_PARA_MARK"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)paraMarkLabel, gridBagConstraints);
        this.paraMarkText = new JTextField();
        this.paraMarkText.setText(Preferences.getPreferenceDefault("mark_para_delimitation_text", "\u2014 \u00b6 \u00e2\u0080\u0094 ${entryKeyID} \u00e2\u0080\u0094\u00e2\u0080\u0094\u00e2\u0080\u0094\u00e2\u0080\u0094\u00e2\u0080\u0094\u00e2\u0080\u0094\u00e2\u0080\u0094\\n"));
        this.paraMarkText.getDocument().addDocumentListener(new RegexHighlightListener(this.paraMarkText, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.paraMarkText, gridBagConstraints);
        JLabel variablesLabel = new JLabel();
        Mnemonics.setLocalizedText(variablesLabel, bundle.getString("MOD_INFO_TEMPLATE_VARIABLES"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)variablesLabel, gridBagConstraints);
        JComboBox<String> variablesListMarker = new JComboBox<String>();
        variablesListMarker.setModel(new DefaultComboBoxModel<String>(ParagraphMarkerVarExpansion.VARIABLES));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add(variablesListMarker, gridBagConstraints);
        JButton insertButton = new JButton();
        Mnemonics.setLocalizedText(insertButton, bundle.getString("BUTTON_INSERT"));
        insertButton.addActionListener(ev -> this.paraMarkText.replaceSelection(variablesListMarker.getSelectedItem().toString()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)insertButton, gridBagConstraints);
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        this.modInfoTemplate.replaceSelection(this.variablesList.getSelectedItem().toString());
    }

    private void insertButtonNDActionPerformed(ActionEvent evt) {
        this.modInfoTemplateND.replaceSelection(this.variablesListND.getSelectedItem().toString());
    }

    private void templateActivatorActionPerformed(ActionEvent evt) {
        this.templatesSetEnabled(this.templateActivator.isSelected());
    }

    private void templatesSetEnabled(boolean isEnabled) {
        this.modInfoTemplate.setEnabled(isEnabled);
        this.templateLabel.setEnabled(isEnabled);
        this.variablesLabel.setEnabled(isEnabled);
        this.variablesList.setEnabled(isEnabled);
        this.insertButton.setEnabled(isEnabled);
        this.modInfoTemplateND.setEnabled(isEnabled);
        this.templateLabelND.setEnabled(isEnabled);
        this.variablesLabelND.setEnabled(isEnabled);
        this.variablesListND.setEnabled(isEnabled);
        this.insertButtonND.setEnabled(isEnabled);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("view_editor_zone_start_end", this.startEndSegment.isSelected());
        Preferences.setPreference("view_editor_zone_line_breaks", this.libeBreaks.isSelected());
        Preferences.setPreference("view_editor_zone_display_origin", this.dispOrigin.isSelected());
        Preferences.setPreference("view_editor_zone_blank_typing", this.colorTyping.isSelected());
        Preferences.setPreference("view_option_source_all_bold", this.viewSourceAllBold.isSelected());
        Preferences.setPreference("view_option_unique_first", this.markFirstNonUnique.isSelected());
        Preferences.setPreference("view_option_ppt_simplify", this.simplifyPPTooltips.isSelected());
        Preferences.setPreference("view_option_template_active", this.templateActivator.isSelected());
        Preferences.setPreference("view_option_mod_info_template", this.modInfoTemplate.getText());
        Preferences.setPreference("view_option_mod_info_template_wo_date", this.modInfoTemplateND.getText());
        Preferences.setPreference("mark_para_delimitation_text", this.paraMarkText.getText());
        ModificationInfoManager.reset();
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

