/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import org.omegat.core.Core;
import org.omegat.gui.editor.mark.CharMarker;
import org.omegat.gui.editor.mark.SymbolPainter;
import org.omegat.util.OStrings;
import org.omegat.util.gui.Styles;

public class WhitespaceMarkerFactory {

    public static class LFMarker
    extends CharMarker {
        public LFMarker() throws Exception {
            this.PAINTER = new SymbolPainter(Styles.EditorColor.COLOR_WHITESPACE.getColor(), "\u00b6");
            this.toolTip = "LF";
            this.patternChar = (char)10;
        }

        @Override
        protected boolean isEnabled() {
            return Core.getEditor().getSettings().isMarkWhitespace();
        }
    }

    public static class TabMarker
    extends CharMarker {
        public TabMarker() throws Exception {
            this.PAINTER = new SymbolPainter(Styles.EditorColor.COLOR_WHITESPACE.getColor(), "\u00bb");
            this.toolTip = OStrings.getString("MARKER_TAB");
            this.patternChar = (char)9;
        }

        @Override
        protected boolean isEnabled() {
            return Core.getEditor().getSettings().isMarkWhitespace();
        }
    }

    public static class SpaceMarker
    extends CharMarker {
        public SpaceMarker() throws Exception {
            this.PAINTER = new SymbolPainter(Styles.EditorColor.COLOR_WHITESPACE.getColor(), "\u00b7");
            this.toolTip = null;
            this.patternChar = (char)32;
        }

        @Override
        protected boolean isEnabled() {
            return Core.getEditor().getSettings().isMarkWhitespace();
        }
    }
}

