/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.filters2;

import gen.core.filters.Filter;
import gen.core.filters.Filters;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.FiltersTableModel;
import org.omegat.gui.filters2.FilterEditor;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.TableColumnSizer;
import org.openide.awt.Mnemonics;

public class FiltersCustomizer
extends JDialog
implements ListSelectionListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    public Filters result;
    private final Filters defaultFilters;
    private Filters editableFilters;
    private final boolean isProjectSpecific;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JCheckBox cbIgnoreFileContext;
    private JCheckBox cbPreserveSpaces;
    private JCheckBox cbRemoveSpacesNonseg;
    private JCheckBox cbRemoveTags;
    private JTextArea description;
    private JButton editButton;
    private JScrollPane filtersScrollPane;
    private JTable filtersTable;
    private JLabel jLabel1;
    private JButton okButton;
    private JButton optionsButton;
    private JCheckBox projectSpecificCB;
    private JButton toDefaultsButton;
    private int returnStatus = 0;

    public FiltersCustomizer(Frame parent, boolean projectSpecific, Filters defaultFilters, Filters userFilters, Filters projectFilters) {
        super(parent, true);
        this.isProjectSpecific = projectSpecific;
        this.defaultFilters = defaultFilters;
        if (userFilters == null) {
            userFilters = defaultFilters;
        }
        this.editableFilters = this.isProjectSpecific && projectFilters != null ? FilterMaster.cloneConfig(projectFilters) : FilterMaster.cloneConfig(userFilters);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.filtersTable.setModel(new FiltersTableModel(this.editableFilters));
        this.filtersTable.getSelectionModel().addListSelectionListener(this);
        this.filtersTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (this.isLeftDoubleClick(me) && this.isClickOnFileFormatColumn(me)) {
                    FiltersCustomizer.this.editButtonActionPerformed(null);
                }
            }

            private boolean isLeftDoubleClick(MouseEvent me) {
                return me.getClickCount() == 2 && me.getButton() == 1;
            }

            private boolean isClickOnFileFormatColumn(MouseEvent me) {
                int viewColumnIndex = FiltersCustomizer.this.filtersTable.columnAtPoint(me.getPoint());
                int modelColumnIndex = FiltersCustomizer.this.filtersTable.convertColumnIndexToModel(viewColumnIndex);
                return modelColumnIndex == FiltersTableModel.COLUMN.FILTERS_FILE_FORMAT.index;
            }
        });
        String columnName = FiltersTableModel.COLUMN.FILTERS_FILE_FORMAT.getColumnName();
        TableColumn column = this.filtersTable.getColumn(columnName);
        column.setCellRenderer(new FilterFormatCellRenderer(this.getInUseFormatNames()));
        TableColumnSizer.autoSize(this.filtersTable, 0, true);
        if (projectSpecific) {
            this.setTitle(OStrings.getString("FILTERSCUSTOMIZER_TITLE_PROJECTSPECIFIC"));
        } else {
            this.projectSpecificCB.setVisible(false);
        }
        if (projectSpecific) {
            this.projectSpecificCB.setSelected(projectFilters != null);
        }
        this.projectSpecificCBActionPerformed(null);
        this.cbRemoveTags.setSelected(this.editableFilters.isRemoveTags());
        this.cbRemoveSpacesNonseg.setSelected(this.editableFilters.isRemoveSpacesNonseg());
        this.cbPreserveSpaces.setSelected(this.editableFilters.isPreserveSpaces());
        this.cbIgnoreFileContext.setSelected(this.editableFilters.isIgnoreFileContext());
        Dimension tableSize = this.filtersTable.getPreferredSize();
        tableSize.height += 70;
        this.filtersScrollPane.setPreferredSize(tableSize);
        this.pack();
        StaticUIUtils.fitInScreen(this);
        DockingUI.displayCentered(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.editButton.setEnabled(false);
            this.optionsButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            int fIdx = this.filtersTable.getSelectedRow();
            Filter currFilter = this.editableFilters.getFilters().get(fIdx);
            IFilter f = FilterMaster.getFilterInstance(currFilter.getClassName());
            this.optionsButton.setEnabled(f.hasOptions());
        }
    }

    public Filters getResult() {
        return this.result;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.toDefaultsButton = new JButton();
        this.jLabel1 = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.filtersScrollPane = new JScrollPane();
        this.filtersTable = new JTable();
        this.description = new JTextArea();
        this.editButton = new JButton();
        this.optionsButton = new JButton();
        this.projectSpecificCB = new JCheckBox();
        this.cbRemoveTags = new JCheckBox();
        this.cbRemoveSpacesNonseg = new JCheckBox();
        this.cbPreserveSpaces = new JCheckBox();
        this.cbIgnoreFileContext = new JCheckBox();
        this.setTitle(OStrings.getString("FILTERSCUSTOMIZER_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FiltersCustomizer.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText(this.toDefaultsButton, OStrings.getString("BUTTON_TO_DEFAULTS"));
        this.toDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.toDefaultsButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.toDefaultsButton);
        this.jLabel1.setPreferredSize(new Dimension(20, 0));
        this.buttonPanel.add(this.jLabel1);
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.filtersScrollPane.setFocusable(false);
        this.filtersScrollPane.setViewportView(this.filtersTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.filtersScrollPane, gridBagConstraints);
        this.description.setEditable(false);
        this.description.setFont(new JLabel().getFont());
        this.description.setLineWrap(true);
        this.description.setText(OStrings.getString("FILTERSCUSTOMIZER_DESCRIPTION"));
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.description.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.description, gridBagConstraints);
        Mnemonics.setLocalizedText(this.editButton, OStrings.getString("BUTTON_EDIT"));
        this.editButton.setToolTipText(OStrings.getString("FILTERSCUSTOMIZER_BUTTON_EDIT_HINT"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.editButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.optionsButton, OStrings.getString("FILTERSCUSTOMIZER_BUTTON_OPTIONS"));
        this.optionsButton.setEnabled(false);
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.optionsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.optionsButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.projectSpecificCB, OStrings.getString("FILTERSCUSTOMIZER_CHECKBOX_PROJECTSPECIFIC"));
        this.projectSpecificCB.setHorizontalAlignment(2);
        this.projectSpecificCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.projectSpecificCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.projectSpecificCB, gridBagConstraints);
        Mnemonics.setLocalizedText(this.cbRemoveTags, OStrings.getString("FILTERSCUSTOMIZER_OPTION_GLOBAL_REMOVE_TAGS"));
        this.cbRemoveTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.cbRemoveTagsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.cbRemoveTags, gridBagConstraints);
        Mnemonics.setLocalizedText(this.cbRemoveSpacesNonseg, OStrings.getString("FILTERSCUSTOMIZER_OPTION_GLOBAL_REMOVE_SPACES_NONSEG"));
        this.cbRemoveSpacesNonseg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.cbRemoveSpacesNonsegActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.cbRemoveSpacesNonseg, gridBagConstraints);
        Mnemonics.setLocalizedText(this.cbPreserveSpaces, OStrings.getString("FILTERSCUSTOMIZER_OPTION_GLOBAL_PRESERVE_SPACES"));
        this.cbPreserveSpaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.cbPreserveSpacesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.cbPreserveSpaces, gridBagConstraints);
        Mnemonics.setLocalizedText(this.cbIgnoreFileContext, OStrings.getString("FILTERSCUSTOMIZER_OPTION_GLOBAL_IGNORE_FILE"));
        this.cbIgnoreFileContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.cbIgnoreFileContextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.cbIgnoreFileContext, gridBagConstraints);
    }

    private void projectSpecificCBActionPerformed(ActionEvent evt) {
        if (this.projectSpecificCB.isSelected() || !this.isProjectSpecific) {
            this.filtersTable.setEnabled(true);
            this.filtersTable.setFocusable(true);
            this.cbRemoveTags.setEnabled(true);
            this.cbRemoveSpacesNonseg.setEnabled(true);
            this.cbPreserveSpaces.setEnabled(true);
            this.cbIgnoreFileContext.setEnabled(true);
            this.toDefaultsButton.setEnabled(true);
        } else {
            this.filtersTable.setEnabled(false);
            this.filtersTable.setFocusable(false);
            this.filtersTable.getSelectionModel().clearSelection();
            this.cbRemoveTags.setEnabled(false);
            this.cbRemoveSpacesNonseg.setEnabled(false);
            this.cbPreserveSpaces.setEnabled(false);
            this.cbIgnoreFileContext.setEnabled(false);
            this.toDefaultsButton.setEnabled(false);
        }
    }

    private void cbRemoveTagsActionPerformed(ActionEvent evt) {
        this.editableFilters.setRemoveTags(this.cbRemoveTags.isSelected());
    }

    private void cbRemoveSpacesNonsegActionPerformed(ActionEvent evt) {
        this.editableFilters.setRemoveSpacesNonseg(this.cbRemoveSpacesNonseg.isSelected());
    }

    private void cbPreserveSpacesActionPerformed(ActionEvent evt) {
        this.editableFilters.setPreserveSpaces(this.cbPreserveSpaces.isSelected());
    }

    private void cbIgnoreFileContextActionPerformed(ActionEvent evt) {
        this.editableFilters.setIgnoreFileContext(this.cbIgnoreFileContext.isSelected());
    }

    private void optionsButtonActionPerformed(ActionEvent evt) {
        int fIdx = this.filtersTable.getSelectedRow();
        Filter currFilter = this.editableFilters.getFilters().get(fIdx);
        IFilter f = FilterMaster.getFilterInstance(currFilter.getClassName());
        Map<String, String> newConfig = f.changeOptions(this, FilterMaster.forFilter(currFilter.getOption()));
        if (newConfig != null) {
            FilterMaster.setOptions(currFilter, newConfig);
        }
    }

    private void toDefaultsButtonActionPerformed(ActionEvent evt) {
        this.editableFilters = FilterMaster.cloneConfig(this.defaultFilters);
        this.filtersTable.setModel(new FiltersTableModel(this.editableFilters));
        this.cbRemoveTags.setSelected(this.editableFilters.isRemoveTags());
        this.cbRemoveSpacesNonseg.setSelected(this.editableFilters.isRemoveSpacesNonseg());
        this.cbPreserveSpaces.setSelected(this.editableFilters.isPreserveSpaces());
        this.cbIgnoreFileContext.setSelected(this.editableFilters.isIgnoreFileContext());
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int row = this.filtersTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        FilterEditor editor = new FilterEditor((Dialog)this, this.editableFilters.getFilters().get(row));
        editor.setVisible(true);
        if (editor.result != null) {
            this.editableFilters.getFilters().set(row, editor.result);
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.result = this.isProjectSpecific && !this.projectSpecificCB.isSelected() ? null : this.editableFilters;
        this.setVisible(false);
        this.dispose();
    }

    private Set<String> getInUseFormatNames() {
        HashSet<String> inUseFormatNames = new HashSet<String>();
        IProject project = Core.getProject();
        if (project.isProjectLoaded()) {
            boolean noProjectSpecificFiltersAvailable;
            Filters projectSpecificFilters = Core.getProject().getProjectProperties().getProjectFilters();
            boolean bl = noProjectSpecificFiltersAvailable = projectSpecificFilters == null;
            if (this.isProjectSpecific || noProjectSpecificFiltersAvailable) {
                for (IProject.FileInfo fi : project.getProjectFiles()) {
                    inUseFormatNames.add(fi.filterFileFormatName);
                }
            }
        }
        return inUseFormatNames;
    }

    public boolean isProjectSpecific() {
        return this.isProjectSpecific;
    }

    private static class FilterFormatCellRenderer
    extends DefaultTableCellRenderer {
        private final Set<String> highlightFormatNames;

        private FilterFormatCellRenderer(Set<String> highlightFormatNames) {
            this.highlightFormatNames = highlightFormatNames;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (this.highlightFormatNames.contains(value.toString())) {
                component.setFont(component.getFont().deriveFont(1));
            }
            return component;
        }
    }
}

